#pragma once

#include <util/generic/string.h>
#include <util/generic/ptr.h>
#include <util/generic/size_literals.h>

class TBlob;
class TDuration;

namespace NSolomon {
namespace NAgent {

class ITcpServerStatusListener {
public:
    virtual ~ITcpServerStatusListener() = default;

    virtual void OnRequestCompleted(ui64 bytesRead, TDuration time) noexcept = 0;
};

using ITcpServerStatusListenerPtr = THolder<ITcpServerStatusListener>;

class IConnection : public TThrRefBase {
public:
    virtual void Close() = 0;
    virtual const TString& RemoteAddress() const = 0;

    virtual void Write(const TBlob& data) = 0;
};

class TTcpServer {
public:
    class TOptions {
    public:
        TString BindAddress;
        ui16 BindPort;

        // if equals to 1, all requests are accepted and processed on a single
        // thread, otherwise accepts are processed on a dedicated thread
        size_t ThreadCount {1};

        size_t BufferSize {16_KB};
        size_t BacklogSize {100};
    };

    class TConnectionHandler {
    public:
        virtual ~TConnectionHandler() = default;

        virtual void OnConnectionOpen(IConnection*) noexcept {}
        virtual void OnConnectionClose(const TBlob& remainingData) noexcept = 0;

        virtual size_t OnData(const TBlob& data) noexcept = 0;
    };

    class ICallback : public TThrRefBase {
    public:
        ~ICallback() = default;

        virtual TConnectionHandler* CreateHandler() = 0;
    };

    using ICallbackPtr = TIntrusivePtr<ICallback>;

public:
    TTcpServer(ICallbackPtr cb, const TOptions& opts, ITcpServerStatusListener* listener = nullptr);
    ~TTcpServer();

    void Start();
    void Stop();

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

} // namespace NAgent
} // namespace NSolomon
