#pragma once

#include <solomon/agent/lib/thread/pool_provider.h>

#include <util/generic/ptr.h>

namespace NSolomon {
namespace NAgent {

class IAgentPushModule {
public:
    virtual ~IAgentPushModule() = default;

    virtual TStringBuf Name() const = 0;

    virtual void Start() = 0;
    virtual void Stop() = 0;
};

using TAgentPushModulePtr = THolder<IAgentPushModule>;

TAgentPushModulePtr CreateHttpPushModule(
    const class THttpPushModuleConfig& config,
    IThreadPoolProvider& threadPoolProvider,
    class IShardConsumerProvider* writer,
    class IServerStatusListener* listener = nullptr);

} // namespace NAgent
} // namespace NSolomon
