#include "porto.h"

#include <solomon/agent/modules/pull/porto/protos/porto_config.pb.h>

#include <solomon/libs/cpp/sysmon/porto.h>

#include <library/cpp/monlib/encode/legacy_protobuf/legacy_protobuf.h>
#include <library/cpp/monlib/metrics/metric_registry.h>

#include <util/datetime/base.h>

using namespace NMonitoring;

namespace NSolomon {
namespace NAgent {

class TPortoModule: public IPullModule {
public:
    TPortoModule(const TPortoConfig& config, TLabels labels)
        : Labels_{std::move(labels)}
        , Config_{config}
    {
        for (auto&& mapping: config.GetMappings()) {
            Mappings_.push_back(mapping);
        }
    }

    TStringBuf Name() const override {
        return TStringBuf("Porto");
    }

    int Pull(TInstant, IMetricConsumer* consumer) override {
        consumer->OnLabelsBegin();
        for (auto&& label: Labels_) {
            consumer->OnLabel(TString{label.Name()}, TString{label.Value()});
        }

        consumer->OnLabelsEnd();

        Porto data;

        const auto isContainerized = Config_.GetContainerized();
        if (isContainerized) {
            std::optional<TString> volumeRegex;
            if (!Config_.GetVolumeRegex().empty()) {
                volumeRegex = Config_.GetVolumeRegex();
            }

            data = GetPortoSelf(volumeRegex);
        }

        // if both containerized is false and mappings are empty will fetch all
        if (!(isContainerized && Mappings_.empty())) {
            data.MergeFrom(GetPortoStats(Mappings_));
        }

        NMonitoring::DecodeLegacyProtoToStream(data, consumer);

        return 0;
    }

private:
    TLabels Labels_;
    TPortoConfig Config_;
    TVector<TString> Mappings_;
};

IPullModulePtr CreatePortoPullModule(
    const TLabels& labels, const TPortoConfig& config) {
    return new TPortoModule{config, labels};
}

} // namespace NAgent
} // namespace NSolomon
