#pragma once

#include <library/cpp/monlib/metrics/labels.h>

#include <util/datetime/base.h>

#include <Python.h>

// TODO: move to agent/lib/python2 library
namespace NSolomon {
namespace NAgent {

void PyDictToLabels(const PyObject* o, NMonitoring::TLabels* labels);
void PyDictForEach(
        const PyObject* o,
        std::function<void(TStringBuf, TStringBuf)> fn);

TVector<double> PyListToVectorFloat(const PyObject*);
TVector<ui64> PyListToVectorUi64(const PyObject*);

double PyNumberToDouble(const PyObject* o);
PyObject* DoubleToPyNumber(double value);

i64 PyNumberToLong(const PyObject* o);
PyObject* LongToPyNumber(i64 value);


ui32 PyNumberToUnsignedInt32(const PyObject* o);
ui64 PyNumberToUnsignedLong(const PyObject* o);
PyObject* UnsignedLongToPyNumber(ui64 value);

TInstant PyNumberToInstant(const PyObject* o);
PyObject* InstantToPyNumber(TInstant value);

} // namespace NAgent
} // namespace NSolomon
