#include <solomon/agent/modules/pull/system/os_impl.h>
#include <solomon/agent/modules/pull/system/protos/system_config.pb.h>

#include <solomon/libs/cpp/sysmon/proc.h>

#include <library/cpp/monlib/encode/legacy_protobuf/legacy_protobuf.h>

namespace NSolomon {
namespace NAgent {

class TLinuxPuller : public ISystemPullerImpl {
public:
    TLinuxPuller(const TSystemConfig& config)
        : Config_{config}
    {
    }

    void Pull(NMonitoring::IMetricConsumer* consumer) override {
        Sysmon sysmon;

        const auto cpuLevel = Config_.GetCpu();
        if (cpuLevel == TSystemConfig::BASIC) {
            ProcCpuinfo(&sysmon);
        } else if (cpuLevel == TSystemConfig::ADVANCED) {
            ProcCpuinfo(&sysmon);
            ProcStatCpu(&sysmon);
            ProcNuma(&sysmon);
        }

        // Same for memory
        if (Config_.GetMemory() != TSystemConfig::NONE) {
            ProcMemory(&sysmon);
        }

        const auto networkLevel = Config_.GetNetwork();
        if (networkLevel == TSystemConfig::BASIC) {
            ProcNetBasic(&sysmon);
        } else if (networkLevel == TSystemConfig::ADVANCED) {
            ProcNetAdvanced(&sysmon);
        }

        if (Config_.GetStorage() != TSystemConfig::NONE) {
            ProcFilesystem(&sysmon);
        }

        if (Config_.GetIo() != TSystemConfig::NONE) {
            ProcDiskstats(&sysmon);
        }

        if (Config_.GetKernel() != TSystemConfig::NONE) {
            ProcKernel(&sysmon);
        }

        NMonitoring::DecodeLegacyProtoToStream(sysmon, consumer);
    }

private:
    TSystemConfig Config_;
};

ISystemPullerImplPtr CreateSysStatPuller(const TSystemConfig& config) {
    return ::MakeHolder<TLinuxPuller>(config);
}

} // namespace NAgent
} // namespace NSolomon
