#include "system.h"
#include "os_impl.h"

#include <solomon/agent/modules/pull/system/protos/system_config.pb.h>

#include <util/datetime/base.h>

using namespace NMonitoring;

namespace NSolomon {
namespace NAgent {
namespace {

class TSystemModule: public IPullModule {
public:
    TSystemModule(const TSystemConfig& config, const TLabels& labels)
        : Labels_{labels}
        , Impl_{CreateSysStatPuller(config)}
    {
    }

private:
    TStringBuf Name() const override {
        return TStringBuf("System");
    }

    int Pull(TInstant, NMonitoring::IMetricConsumer* consumer) override {
        consumer->OnLabelsBegin();
        for (auto&& label: Labels_) {
            consumer->OnLabel(TString{label.Name()}, TString{label.Value()});
        }

        consumer->OnLabelsEnd();

        Impl_->Pull(consumer);

        return 0;
    }

private:
    TLabels Labels_;
    ISystemPullerImplPtr Impl_;
};

} // namespace


IPullModulePtr CreateSystemModule(const TLabels& labels, const TSystemConfig& config) {
    return new TSystemModule(config, labels);
}

} // namespace NAgent
} // namespace NSolomon
