#include "systemd.h"
#include <solomon/agent/misc/logger.h>

namespace NSolomon::NAgent {
namespace {
    struct TFakeSystemd: public IPullModule {
        int Pull(TInstant, NMonitoring::IMetricConsumer*) override {
            return -1;
        }

        TStringBuf Name() const override {
            return TStringBuf("Systemd");
        }
    };
} // namespace
    IPullModulePtr CreateSystemdPullModule(const TLabels&, const TSystemdConfig&) {
        SA_LOG(FATAL) << "Current system does not support systemd. You can not to use this service.";
        return new TFakeSystemd;
    }
}
