#include "systemd.h"
#include "worker.h"

#include <solomon/agent/modules/pull/systemd/protos/systemd_pull_config.pb.h>

#include <library/cpp/monlib/metrics/metric_type.h>

#include <util/datetime/base.h>

namespace NSolomon::NAgent {
    class TSystemdPullModule: public IPullModule {
    public:
        TSystemdPullModule(const TLabels& labels, const TSystemdConfig& config)
            : Labels_{std::move(labels)}
            , Worker_(CreateWorker(config))
        {
        }

        TStringBuf Name() const override {
            return TStringBuf("Systemd");
        }

        // non-zero return code indicates that this module should not be called anymore
        int Pull(TInstant, NMonitoring::IMetricConsumer* consumer) override {
            consumer->OnLabelsBegin();
            for (auto&& label: Labels_) {
                consumer->OnLabel(label.Name(), label.Value());
            }
            consumer->OnLabelsEnd();

            Worker_->GetMetrics(consumer);

            return 0;
        }

    private:
        const TLabels Labels_;
        THolder<IWorker> Worker_;
    };

    IPullModulePtr CreateSystemdPullModule(const TLabels& labels, const TSystemdConfig& config) {
        return new TSystemdPullModule(labels, config);
    }
}
