#pragma once

#include <library/cpp/monlib/metrics/fwd.h>

#include <util/generic/ptr.h>
#include <util/generic/strbuf.h>

#include <contrib/libs/sdbus-cpp/include/sdbus-c++/sdbus-c++.h>

namespace NSolomon::NAgent {
    class TSystemdConfig;

    constexpr TStringBuf SYSTEMD_INTERFACE = "org.freedesktop.systemd1";
    constexpr TStringBuf SERVICE_INTERFACE = "org.freedesktop.systemd1.Service";
    constexpr TStringBuf MANAGER_INTERFACE = "org.freedesktop.systemd1.Manager";
    constexpr TStringBuf DEFAULT_SERVICES_PATH = "/org/freedesktop/systemd1";

    // https://www.freedesktop.org/wiki/Software/systemd/dbus/
    using SDBusReply = sdbus::Struct<
        std::string /* (0) The primary unit name as string */,
        std::string /* (1) The human readable description string */,
        std::string /* (2) The load state (i.e. whether the unit file has been loaded successfully) */,
        std::string /* (3) The active state (i.e. whether the unit is currently started or not) */,
        std::string /* (4) The sub state (a more fine-grained version of the active state that is specific to the unit type, which the active state is not) */,
        std::string /* (5) A unit that is being followed in its state by this unit, if there is any, otherwise the empty string. */,
        sdbus::ObjectPath /* (6) The unit object path */,
        ui32 /* (7) If there is a job queued for the job unit the numeric job id, 0 otherwise */,
        std::string /* (8) The job type as string */,
        sdbus::ObjectPath /* (9) The job object path */>;

    struct TSystemdSettings {
        TStringBuf SystemdInterface = SYSTEMD_INTERFACE;
        TStringBuf ServiceInterface = SERVICE_INTERFACE;
        TStringBuf ManagerInterface = MANAGER_INTERFACE;
        TStringBuf DefaultInterfacePath = DEFAULT_SERVICES_PATH;
    };

    class IWorker {
    public:
        virtual ~IWorker() = default;

        virtual void GetMetrics(NMonitoring::IMetricConsumer* consumer) = 0;
    };

    THolder<IWorker> CreateWorker(const TSystemdConfig& config);

    // For unit testing
    THolder<IWorker> CreateWorker(
            const TSystemdConfig& config,
            const TSystemdSettings& settings,
            sdbus::IConnection& connection);
}
