#!/bin/sh -e

SECRETS="../../tools/secrets/secrets"

ENVIRON="preprod"
YAV_KEY="sec-01esbrr667re3f3jpmr8yh8hrr"
KMS_KEY="e102eb83tdq16u83u183"

crt_encrypt() {
    local crt_id="$1" crt_name="$2" sec_id sec_data crt_data key_data

    sec_id=$(yav list secrets -q $crt_id --compact | awk 'FNR == 3 {print $1}')
    if [ -z "$sec_id" ] ; then
        echo "No secrets found for $crt_id!"
        exit 1
    fi
    echo "Using sec id '$sec_id'"

    sec_data="$(yav get version $sec_id -j)"
    crt_data="$(python -c 'D = '"$sec_data"'; print(D["value"]["'${crt_id}'_certificate"])')"
    key_data="$(python -c 'D = '"$sec_data"'; print(D["value"]["'${crt_id}'_private_key"])')"

    echo "$crt_data" | ${SECRETS} encrypt \
            --kms-env ${ENVIRON} \
            --kms-key ${KMS_KEY} \
            --yav-key ${YAV_KEY}/gateway \
            --in - \
            --out ssl.${crt_name}_cert

    echo "$key_data" | ${SECRETS} encrypt \
            --kms-env ${ENVIRON} \
            --kms-key ${KMS_KEY} \
            --yav-key ${YAV_KEY}/gateway \
            --in - \
            --out ssl.${crt_name}_key
}


../../../ya make $(dirname ${SECRETS})

# monitoring.api.cloud{,-preprod}.yandex.net
crt_encrypt 27321EC29F84E7F827A77949 monitoring_api

# monitoring.private-api.cloud{,-preprod}.yandex.net
crt_encrypt 7F001AEED5FC68C8D391117E810002001AEED5 monitoring_private_api

# solomon.cloud{,-preprod}.yandex-team.ru
crt_encrypt 7F001DFBE4545919365BE5119E0002001DFBE4 default
