#!/bin/sh -e

SECRETS="../../tools/secrets/secrets"

../../../ya make $(dirname ${SECRETS})

encrypt() {
    local service="$1"
    local yav_key="$2"
    local kms_key="$3"

    ${SECRETS} get --config ${service}.conf | ${SECRETS} encrypt \
            --kms-env preprod \
            --kms-key ${kms_key} \
            --yav-key sec-01esbrr667re3f3jpmr8yh8hrr/${yav_key} \
            --in - \
            --out ${service}.secrets
}

encryptKey() {
    local key="$1"
    local yav_key="$2"
    local kms_key="$3"
    local out="$4"

    ${SECRETS} get-key --key "${key}" | ${SECRETS} encrypt \
            --kms-env preprod \
            --kms-key ${kms_key} \
            --yav-key sec-01esbrr667re3f3jpmr8yh8hrr/${yav_key} \
            --in - \
            --out ${out}
}

encrypt gateway gateway e102eb83tdq16u83u183
encryptKey "yav://sec-01esbrr667re3f3jpmr8yh8hrr/gateway" gateway e102eb83tdq16u83u183 gateway_lb_producer_key.secret
encryptKey "yav://sec-01esbrr667re3f3jpmr8yh8hrr/monitoring-service-provider" gateway e102eb83tdq16u83u183 gateway_agent.secret
encryptKey "yav://sec-01ddjr1pgkrp7jr2vrbgqvm4hp/tvm-prestable" gateway e102eb83tdq16u83u183 unified_agent_tvm.secret
encryptKey "yav://sec-01esbrr667re3f3jpmr8yh8hrr/fetcher" fetcher e10nrgijsr1f9jm33nq4 name_resolver_lb_producer_key.secret
encryptKey "yav://sec-01esbrr667re3f3jpmr8yh8hrr/fetcher" fetcher e10nrgijsr1f9jm33nq4 coremon_lb_producer_key.secret
encrypt alerting alerting e10ucqlb0hlgp2k49dui
encrypt name-resolver fetcher e10nrgijsr1f9jm33nq4
#encrypt fetcher fetcher e10nrgijsr1f9jm33nq4
#encrypt stockpile stockpile e10kjel482t8gt9abq5s
