#!/bin/sh -e

SECRETS="../../tools/secrets/secrets"

ENVIRON="prod"
YAV_KEY="sec-01evvgkgrgy6tvgrhgpq722e1f"
KMS_KEY="abjfi7or6lggst1518gt"

crt_encrypt() {
    local crt_id="$1" crt_name="$2" sec_id sec_data crt_data key_data

    sec_id=$(yav list secrets -q $crt_id --compact | awk 'FNR == 3 {print $1}')
    if [ -z "$sec_id" ] ; then
        echo "No secrets found for $crt_id!"
        exit 1
    fi
    echo "Using sec id '$sec_id'"

    sec_data="$(yav get version $sec_id -j)"
    crt_data="$(python -c 'D = '"$sec_data"'; print(D["value"]["'${crt_id}'_certificate"])')"
    key_data="$(python -c 'D = '"$sec_data"'; print(D["value"]["'${crt_id}'_private_key"])')"

    echo "$crt_data" | ${SECRETS} encrypt \
            --kms-env ${ENVIRON} \
            --kms-key ${KMS_KEY} \
            --yav-key ${YAV_KEY}/gateway \
            --in - \
            --out ssl.${crt_name}_cert

    echo "$key_data" | ${SECRETS} encrypt \
            --kms-env ${ENVIRON} \
            --kms-key ${KMS_KEY} \
            --yav-key ${YAV_KEY}/gateway \
            --in - \
            --out ssl.${crt_name}_key
}


../../../ya make $(dirname ${SECRETS})

# monitoring.api.cloud{,-preprod}.yandex.net
crt_encrypt 39ED0D45781373D98ADEDF56 monitoring_api

# monitoring.private-api.cloud{,-preprod}.yandex.net
crt_encrypt 7F001AEED2EE07EAF93FC63D5E0002001AEED2 monitoring_private_api

# solomon.cloud{,-preprod}.yandex-team.ru
crt_encrypt 7F001DFBE20C9787A8D3B09EA40002001DFBE2 default
