#!/bin/sh -e

SECRETS="../../tools/secrets/secrets"

../../../ya make $(dirname ${SECRETS})

encrypt() {
    local service="$1"
    local yav_key="$2"
    local kms_key="$3"

    ${SECRETS} get --config ${service}.conf | ${SECRETS} encrypt \
            --kms-env prod \
            --kms-key ${kms_key} \
            --yav-key sec-01evvgkgrgy6tvgrhgpq722e1f/${yav_key} \
            --in - \
            --out ${service}.secrets
}

encryptKey() {
    local key="$1"
    local yav_key="$2"
    local kms_key="$3"
    local out="$4"

    ${SECRETS} get-key --key "${key}" | ${SECRETS} encrypt \
            --kms-env prod \
            --kms-key ${kms_key} \
            --yav-key sec-01evvgkgrgy6tvgrhgpq722e1f/${yav_key} \
            --in - \
            --out ${out}
}

encrypt gateway gateway abjfi7or6lggst1518gt
encryptKey "yav://sec-01evvgkgrgy6tvgrhgpq722e1f/gateway" gateway abjfi7or6lggst1518gt gateway_lb_producer_key.secret
encryptKey "yav://sec-01evvgkgrgy6tvgrhgpq722e1f/monitoring-service-provider" gateway abjfi7or6lggst1518gt gateway_agent.secret
encryptKey "yav://sec-01ddjr1pgkrp7jr2vrbgqvm4hp/tvm-production" gateway abjfi7or6lggst1518gt unified_agent_tvm.secret
encryptKey "yav://sec-01evvgkgrgy6tvgrhgpq722e1f/fetcher" fetcher abj6v92so7qbfukqhb4m name_resolver_lb_producer_key.secret
encryptKey "yav://sec-01evvgkgrgy6tvgrhgpq722e1f/fetcher" fetcher abj6v92so7qbfukqhb4m coremon_lb_producer_key.secret
encrypt alerting alerting abjbqaufnigm0v1sgecm
encrypt name-resolver.sas fetcher abj6v92so7qbfukqhb4m
encrypt name-resolver.vla fetcher abj6v92so7qbfukqhb4m
#encrypt fetcher abj6v92so7qbfukqhb4m
#encrypt stockpile abjfdcruua2bam4u8ibp
