#!/usr/bin/env python3

import glob
import re
import requests


TVMID = re.compile(r'^.*\b(?P<tvmid>\d{7})\b[^#]*$')

def resolve_by_id(tvmid):
    resp = requests.get("https://tvm.yandex-team.ru/client/{tvmid}/info".format(tvmid=tvmid))
    resp.raise_for_status()
    r = resp.json()
    return '{name} @ https://abc.yandex-team.ru/services/{abc_service_id}/'.format(**r)

def patch(line):
    m = TVMID.match(line)
    if m is not None:
        tvmid = m.group("tvmid")
        return line + ' # ' + resolve_by_id(tvmid)
    return line


for fn in glob.glob('*/*.conf'):
    print('Processing', fn)
    lines = []
    with open(fn, 'r') as f:
        for line in f:
            line = line.rstrip()
            lines.append(patch(line))

    with open(fn, 'w') as f:
        for line in lines:
            f.write(line + '\n')
