#!/bin/sh -e

SECRETS_DIR="../../tools/secrets"
KEY="sec-01erybhveah0qkgnx1yq9027n2/prestable"
SERVICES="
    alerting
    coremon
    dumper
    fetcher
    gateway
    ingestor
    stockpile
    project-manager
    name-resolver
    metabase
"

encrypt_by_id() {
    local sec_id="$1" name="$2" file="$3" sec_data value

    echo "Using sec id $sec_id"
    sec_data="$(yav get version $sec_id -j)"
    value="$(python -c 'D = '"$sec_data"'; print(D["value"]["'${name}'"])')"
    echo "$value" | ${SECRETS_DIR}/secrets encrypt \
        --yav-key sec-01erybhveah0qkgnx1yq9027n2/prestable \
        --in - \
        --out $file
}

ya make ${SECRETS_DIR}

encrypt_by_id sec-01fv2r3bvwvsga6btnw898q397 client_secret gateway_lb_producer_key.secret

for service in ${SERVICES}; do
    ${SECRETS_DIR}/secrets get --config ${service}.conf \
        | ${SECRETS_DIR}/secrets encrypt --yav-key ${KEY} --in - --out ${service}.secrets
done
