#!/bin/sh -e

SECRETS="../../tools/secrets/secrets"

ya make $(dirname ${SECRETS})

encrypt_by_id() {
    local sec_id="$1" name="$2" file="$3" sec_data value

    echo "Using sec id $sec_id"
    sec_data="$(yav get version $sec_id -j)"
    value="$(python -c 'D = '"$sec_data"'; print(D["value"]["'${name}'"])')"
    echo "$value" | ${SECRETS} encrypt \
        --yav-key sec-01erybhveah0qkgnx1yq9027n2/production \
        --in - \
        --out $file
}

encrypt() {
    if [ $# -eq 2 ]; then
        local config="$1"
        local secrets="$2"
    else
        local config="$1.conf"
        local secrets="$1.secrets"
    fi

    ${SECRETS} get --config ${config} | ${SECRETS} encrypt \
            --yav-key sec-01erybhveah0qkgnx1yq9027n2/production \
            --in - \
            --out ${secrets}
}

encrypt_by_id sec-01fv2r2jd8ayqzk9r8e2ggjnb9 client_secret gateway_lb_producer_key.secret

encrypt alerting
encrypt dumper
encrypt gateway
encrypt ingestor
encrypt slicer
encrypt project-manager

encrypt fetcher.conf fetcher.sts.secrets
encrypt fetcher.sas.conf fetcher.secrets
encrypt coremon.sas.conf coremon.secrets
encrypt metabase.sas.conf metabase.secrets
encrypt name-resolver.sas.conf name-resolver.sas.secrets
encrypt name-resolver.vla.conf name-resolver.vla.secrets
encrypt stockpile.sas.conf stockpile.secrets
