package ru.yandex.solomon.configs;

import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.Paths;

import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import org.junit.Test;
import org.junit.runners.Parameterized.Parameter;


/**
 * @author Sergey Polovko
 */
public abstract class ParseConfigsBase {

    private final Message.Builder configBuilder;
    @Parameter
    public String configFile;

    ParseConfigsBase(Message.Builder configBuilder) {
        this.configBuilder = configBuilder;
    }

    @Test
    public void parseConfigs() throws Exception {
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(configFile))) {
            TextFormat.merge(reader, configBuilder);
        }
        configBuilder.build();
    }
}
