package ru.yandex.solomon.configs;

import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;

import ru.yandex.solomon.config.protobuf.stockpile.TStockpileConfig;


/**
 * @author Sergey Polovko
 */
@RunWith(Parameterized.class)
public class ParseStockpileConfigsTest extends ParseConfigsBase {

    public ParseStockpileConfigsTest() {
        super(TStockpileConfig.newBuilder());
    }

    @Parameters(name = "{0}")
    public static String[] configs() {
        return new String[]{
            "dev/stockpile.dev.conf",
            "testing/stockpile.conf",
            "prestable/stockpile.conf",
            "production/stockpile.sas.conf",
            "production/stockpile.vla.conf",
            "cloud-preprod/stockpile.conf",
            "cloud-prod/stockpile.vla.conf",
            "cloud-prod/stockpile.sas.conf"
        };
    }
}
