package ru.yandex.solomon.configs;

import java.util.Optional;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;

import ru.yandex.solomon.config.protobuf.TKikimrClientConfig;
import ru.yandex.solomon.config.protobuf.alert.TAlertingConfig;
import ru.yandex.solomon.util.SolomonEnv;


/**
 * @author Sergey Polovko
 *
 * TODO: inherit this test from {@link ValidateConfigsBase}
 */
@RunWith(Parameterized.class)
public class ValidateAlertingConfigsTest {

    @Parameters(name = "{0}")
    public static String[] configs() {
        return new String[] {
            "dev/alerting.dev-uranix.conf",
            "testing/alerting.conf",
            "prestable/alerting.conf",
            "production/alerting.conf",
        };
    }

    private final Optional<SolomonEnv> parsedEnvType;
    private final TAlertingConfig config;

    public ValidateAlertingConfigsTest(String configFile) {
        this.parsedEnvType = ValidateUtils.parseEnvType(configFile);
        this.config = ValidateConfigsBase.readConfigFromFile(TAlertingConfig.newBuilder(), configFile);
    }

    @Test
    public void validateKikimrConfig() {
        TKikimrClientConfig kikimrConfig = config.getKikimrConfig();
        ValidateUtils.validateKikimrClientConfig(kikimrConfig, Optional.empty(), parsedEnvType, true);
    }
}
