package ru.yandex.solomon.configs;

import java.util.Optional;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;

import ru.yandex.solomon.config.protobuf.TKikimrClientConfig;
import ru.yandex.solomon.config.protobuf.rpc.TRpcServerConfig;
import ru.yandex.solomon.config.protobuf.stockpile.TKvStorageConfig;
import ru.yandex.solomon.config.protobuf.stockpile.TStockpileConfig;
import ru.yandex.solomon.config.protobuf.stockpile.TStockpileThreadPoolsConfig;
import ru.yandex.solomon.util.SolomonEnv;


/**
 * @author alexlovkov
 */
@RunWith(Parameterized.class)
public class ValidateStockpileConfigsTest extends ValidateConfigsBase<TStockpileConfig> {

    @Parameters(name = "{0}")
    public static String[] configs() {
        return new String[]{
            "dev/stockpile.dev.conf",
            "testing/stockpile.conf",
            "prestable/stockpile.conf",
            "production/stockpile.sas.conf",
            "production/stockpile.vla.conf",
        };
    }

    public ValidateStockpileConfigsTest(String configFile) {
        super(configFile, TStockpileConfig.newBuilder());
    }

    @Test
    public void validateKikimrClientConfig() {
        TKikimrClientConfig config = getConfig().getKikimrClientConfig();
        ValidateUtils.validateKikimrClientConfig(config, getKnownDc(), getParsedEnvType(), false);
    }

    @Test
    public void validateKvStorageConfig() {
        TKvStorageConfig config = getConfig().getKvStorageConfig();
        Assert.assertNotSame(TKvStorageConfig.getDefaultInstance(), config);

        Optional<SolomonEnv> envType = getParsedEnvType();
        if (envType.isPresent() &&
            (envType.get() == SolomonEnv.PRESTABLE || envType.get() == SolomonEnv.TESTING))
        {
            String volumePath = config.getVolumePath();
            Assert.assertFalse(volumePath.isEmpty());
            Assert.assertTrue(volumePath.startsWith("/"));
            Assert.assertFalse(volumePath.endsWith("/"));
        }
    }

    @Test
    public void validateRpcServerConfig() {
        TRpcServerConfig config = getConfig().getRpcServerConfig();
        Assert.assertNotEquals(0, config.getGrpcServerConfig().getPort(0));
        validateThreadPoolName(config.getGrpcServerConfig().getThreadPoolName());
    }

    @Test
    public void validateStockpileThreadPoolsConfig() {
        TStockpileThreadPoolsConfig stockpileThreadPoolsConfig = getConfig().getStockpileThreadPoolsConfig();
        validateThreadPoolName(stockpileThreadPoolsConfig.getGeneralThreadPool());
        validateThreadPoolName(stockpileThreadPoolsConfig.getMergeThreadPool());
        validateThreadPoolName(stockpileThreadPoolsConfig.getStockpileReadThreadPool());
    }
}
