#!/bin/bash
# Add Idm tables: ProjectAclEntry, SystemAclEntry, GroupMember

## TESTING

# Add Idm tables
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/development/solomon \
    scripting yql -s 'CREATE TABLE [Acl/V1/ProjectAclEntry] (projectId Utf8, uid Utf8,type Utf8,roles Utf8, version Uint32,primary key (projectId, uid, type));
                        CREATE TABLE [Acl/V1/SystemAclEntry] (uid Utf8,type Utf8,roles Utf8, version Uint32,primary key (uid, type));
                        CREATE TABLE [Acl/V1/GroupMember] (groupId Utf8,userId Utf8,primary key (groupId, userId));
                        COMMIT;'
# Check table scheme
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/development/solomon \
    scheme describe Acl/V1/ProjectAclEntry

ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/development/solomon \
    scheme describe Acl/V1/SystemAclEntry

ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/development/solomon \
    scheme describe Acl/V1/GroupMember

## PRESTABLE

# Add Idm tables
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/prestable/solomon \
    scripting yql -s 'CREATE TABLE [Acl/V1/ProjectAclEntry] (projectId Utf8, uid Utf8,type Utf8,roles Utf8, version Uint32,primary key (projectId, uid, type));
                        CREATE TABLE [Acl/V1/SystemAclEntry] (uid Utf8,type Utf8,roles Utf8, version Uint32,primary key (uid, type));
                        CREATE TABLE [Acl/V1/GroupMember] (groupId Utf8,userId Utf8,primary key (groupId, userId));
                        COMMIT;'

# Check table scheme
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/prestable/solomon \
    scheme describe Acl/V1/ProjectAclEntry

ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/prestable/solomon \
    scheme describe Acl/V1/SystemAclEntry

ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/prestable/solomon \
    scheme describe Acl/V1/GroupMember

## PROD

# Add Idm tables
kikimr db yql --text 'CREATE TABLE [/Kfront/Solomon/Acl/V1/ProjectAclEntry] (projectId Utf8, uid Utf8,type Utf8,roles Utf8, version Uint32,primary key (projectId, uid, type));
                        CREATE TABLE [/Kfront/Solomon/Acl/V1/SystemAclEntry] (uid Utf8,type Utf8,roles Utf8, version Uint32,primary key (uid, type));
                        CREATE TABLE [/Kfront/Solomon/Acl/V1/GroupMember] (groupId Utf8,userId Utf8,primary key (groupId, userId));
                        COMMIT;'

# Check table scheme
kikimr db schema describe -d /Kfront/Solomon/Acl/V1/ProjectAclEntry
kikimr db schema describe -d /Kfront/Solomon/Acl/V1/SystemAclEntry
kikimr db schema describe -d /Kfront/Solomon/Acl/V1/GroupMember
