#!/bin/bash

## Add column

# PREPROD on gateway
sudo ydb -e grpcs://solomon-dn.ydb.cloud-preprod.yandex.net:2136 \
    -d /pre-prod_global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud-preprod.yandex.net \
    scripting yql -s 'alter table [Config/V2/Project] ADD COLUMN metricNameLabel Utf8;'

# CLOUD-PROD on gateway
sudo ydb -e grpcs://solomon-dn.ydb.cloud.yandex.net:2136 \
    -d /global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud.yandex.net \
    scripting yql -s 'alter table [Config/V2/Project] ADD COLUMN metricNameLabel Utf8;'

# GPN on dyn node
sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    scripting yql -s 'alter table [Config/V2/Project] ADD COLUMN metricNameLabel Utf8;'

# TESTING on laptop
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/development/solomon \
    scripting yql -s 'alter table [Config/V2/Project] ADD COLUMN metricNameLabel Utf8;'

# PRESTABLE on laptop
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/prestable/solomon \
    scripting yql -s 'alter table [Config/V2/Project] ADD COLUMN metricNameLabel Utf8;'

# PROD
kikimr db yql --text 'alter table [/Kfront/Solomon/Config/V2/Project] ADD COLUMN metricNameLabel Utf8;'

## Check table schemas

# PREPROD on gateway
sudo ydb -e grpcs://solomon-dn.ydb.cloud-preprod.yandex.net:2136 \
    -d /pre-prod_global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud-preprod.yandex.net \
    scheme describe Config/V2/Project

# CLOUD-PROD on gateway
sudo ydb -e grpcs://solomon-dn.ydb.cloud.yandex.net:2136 \
    -d /global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud.yandex.net \
    scheme describe Config/V2/Project

# GPN on dyn node solomon-dn-spb99-1.svc.gpn.yandexcloud.net
sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    scheme describe Config/V2/Project

# TESTING on laptop
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/development/solomon \
    scheme describe Config/V2/Project

# PRESTABLE on laptop
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/prestable/solomon \
    scheme describe Config/V2/Project

# PROD
kikimr db schema describe -d /Kfront/Solomon/Config/V2/Project
