-- Moving shard rasp_offer_storage_testing_offer_storage from project "rasp" to project "trains",
-- with renaming clusterId and serviceId.
-- See more info in https://st.yandex-team.ru/SOLOMON-5927

INSERT INTO [/Kfront/Solomon/Config/V2/Shard] (
  id,
  numId,
  projectId,
  clusterId,
  serviceId,
  clusterName,
  serviceName,
  maxSensorsPerUrl,
  maxFileSensors,
  maxMemSensors,
  maxResponseSizeBytes,
  decimPolicy,
  sensorsTtlDays,
  state,
  validationMode,
  sensorNameLabel,
  createdAt,
  updatedAt,
  createdBy,
  updatedBy,
  version)
SELECT
  cast("trains_offer_storage_testing_offer_storage" as Utf8),
  numId,
  cast("trains" as Utf8),
  cast("trains_offer_storage_testing" as Utf8),
  cast("trains_offer_storage" as Utf8),
  clusterName,
  serviceName,
  maxSensorsPerUrl,
  maxFileSensors,
  maxMemSensors,
  maxResponseSizeBytes,
  decimPolicy,
  sensorsTtlDays,
  state,
  validationMode,
  sensorNameLabel,
  createdAt,
  updatedAt,
  createdBy,
  updatedBy,
  version
FROM [/Kfront/Solomon/Config/V2/Shard]
WHERE id = "rasp_offer_storage_testing_offer_storage";

INSERT INTO [/Kfront/Solomon/Config/V2/ShardPcsKey] (
    projectId,
    clusterName,
    serviceName,
    id)
SELECT
  cast("trains" as Utf8),
  clusterName,
  serviceName,
  cast("trains_offer_storage_testing_offer_storage" as Utf8)
FROM [/Kfront/Solomon/Config/V2/ShardPcsKey]
WHERE id = "rasp_offer_storage_testing_offer_storage";

COMMIT;

DELETE FROM [/Kfront/Solomon/Config/V2/Shard]
WHERE id = "rasp_offer_storage_testing_offer_storage";

DELETE FROM [/Kfront/Solomon/Config/V2/ShardPcsKey]
WHERE id = "rasp_offer_storage_testing_offer_storage";

UPDATE [/Kfront/Solomon/Config/V2/ShardPcsNumId]
SET id = "trains_offer_storage_testing_offer_storage"
WHERE id = "rasp_offer_storage_testing_offer_storage";

COMMIT;
