-- Moving shard rasp_crosslink_testing_crosslink from project "rasp" to project "trains",
-- with renaming clusterId and serviceId.
-- See more info in https://st.yandex-team.ru/SOLOMON-5928

INSERT INTO [/Kfront/Solomon/Config/V2/Shard] (
  id,
  numId,
  projectId,
  clusterId,
  serviceId,
  clusterName,
  serviceName,
  maxSensorsPerUrl,
  maxFileSensors,
  maxMemSensors,
  maxResponseSizeBytes,
  decimPolicy,
  sensorsTtlDays,
  state,
  validationMode,
  sensorNameLabel,
  createdAt,
  updatedAt,
  createdBy,
  updatedBy,
  version)
SELECT
  cast("trains_crosslink_testing_crosslink" as Utf8),
  numId,
  cast("trains" as Utf8),
  cast("trains_crosslink_testing" as Utf8),
  cast("trains_crosslink" as Utf8),
  clusterName,
  serviceName,
  maxSensorsPerUrl,
  maxFileSensors,
  maxMemSensors,
  maxResponseSizeBytes,
  decimPolicy,
  sensorsTtlDays,
  state,
  validationMode,
  sensorNameLabel,
  createdAt,
  updatedAt,
  createdBy,
  updatedBy,
  version
FROM [/Kfront/Solomon/Config/V2/Shard]
WHERE id = "rasp_crosslink_testing_crosslink";

INSERT INTO [/Kfront/Solomon/Config/V2/ShardPcsKey] (
    projectId,
    clusterName,
    serviceName,
    id)
SELECT
  cast("trains" as Utf8),
  clusterName,
  serviceName,
  cast("trains_crosslink_testing_crosslink" as Utf8)
FROM [/Kfront/Solomon/Config/V2/ShardPcsKey]
WHERE id = "rasp_crosslink_testing_crosslink";

COMMIT;

DELETE FROM [/Kfront/Solomon/Config/V2/Shard]
WHERE id = "rasp_crosslink_testing_crosslink";

DELETE FROM [/Kfront/Solomon/Config/V2/ShardPcsKey]
WHERE id = "rasp_crosslink_testing_crosslink";

UPDATE [/Kfront/Solomon/Config/V2/ShardPcsNumId]
SET id = "trains_crosslink_testing_crosslink"
WHERE id = "rasp_crosslink_testing_crosslink";

COMMIT;
