#!/bin/bash
# Add labels column to tables: Service, Shard, Cluster, Project

## TESTING

# Add labels to tables
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/development/solomon \
    scripting yql -s 'ALTER TABLE [Config/V2/Service] ADD COLUMN labels Utf8;
                        ALTER TABLE [Config/V2/Cluster] ADD COLUMN labels Utf8;
                        ALTER TABLE [Config/V2/Shard] ADD COLUMN labels Utf8;
                        ALTER TABLE [Config/V2/Project] ADD COLUMN labels Utf8;
                        ALTER TABLE [Alerting/V6/Alerts] ADD COLUMN labels Utf8;
                        ALTER TABLE [Alerting/V6/Notifications] ADD COLUMN labels Utf8;'

# Check table scheme, change last line for other tables, change last line for other tables
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/development/solomon \
    scheme describe Config/V2/Service

## PRESTABLE

# Add labels to tables
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/prestable/solomon \
    scripting yql -s 'ALTER TABLE [Config/V2/Service] ADD COLUMN labels Utf8;
                        ALTER TABLE [Config/V2/Cluster] ADD COLUMN labels Utf8;
                        ALTER TABLE [Config/V2/Shard] ADD COLUMN labels Utf8;
                        ALTER TABLE [Config/V2/Project] ADD COLUMN labels Utf8;
                        ALTER TABLE [Alerting/V6/Alerts] ADD COLUMN labels Utf8;
                        ALTER TABLE [Alerting/V6/Notifications] ADD COLUMN labels Utf8;'

# Check table scheme, change last line for other tables
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/prestable/solomon \
    scheme describe Config/V2/Service

## PROD

# Add labels to tables
kikimr db yql --text 'ALTER TABLE [/Kfront/Solomon/Config/V2/Service] ADD COLUMN labels Utf8;
                        ALTER TABLE [/Kfront/Solomon/Config/V2/Cluster] ADD COLUMN labels Utf8;
                        ALTER TABLE [/Kfront/Solomon/Config/V2/Shard] ADD COLUMN labels Utf8;
                        ALTER TABLE [/Kfront/Solomon/Config/V2/Project] ADD COLUMN labels Utf8;
                        ALTER TABLE [/Kfront/Solomon/Alerting/V6/Alerts] ADD COLUMN labels Utf8;
                        ALTER TABLE [/Kfront/Solomon/Alerting/V6/Notifications] ADD COLUMN labels Utf8;'

# Check table scheme, change last line for other tables
kikimr db schema describe -d /Kfront/Solomon/Config/V2/Service

## CLOUD-PREPROD

# Add labels to tables
sudo ydb -e grpcs://solomon-dn.ydb.cloud-preprod.yandex.net:2136 \
    -d /pre-prod_global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud-preprod.yandex.net \
    scripting yql -s 'ALTER TABLE [Config/V2/Service] ADD COLUMN labels Utf8;
                        ALTER TABLE [Config/V2/Cluster] ADD COLUMN labels Utf8;
                        ALTER TABLE [Config/V2/Shard] ADD COLUMN labels Utf8;
                        ALTER TABLE [Config/V2/Project] ADD COLUMN labels Utf8;
                        ALTER TABLE [Alerting/V6/Alerts] ADD COLUMN labels Utf8;
                        ALTER TABLE [Alerting/V6/Notifications] ADD COLUMN labels Utf8;'

# Check table scheme, change last line for other tables
sudo ydb -e grpcs://solomon-dn.ydb.cloud-preprod.yandex.net:2136 \
    -d /pre-prod_global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud-preprod.yandex.net \
    scheme describe Config/V2/Service

## CLOUD-PROD

# Add labels to tables
sudo ydb -e grpcs://solomon-dn.ydb.cloud.yandex.net:2136 \
    -d /global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud.yandex.net \
    scripting yql -s 'ALTER TABLE [Config/V2/Service] ADD COLUMN labels Utf8;
                        ALTER TABLE [Config/V2/Cluster] ADD COLUMN labels Utf8;
                        ALTER TABLE [Config/V2/Shard] ADD COLUMN labels Utf8;
                        ALTER TABLE [Config/V2/Project] ADD COLUMN labels Utf8;
                        ALTER TABLE [Alerting/V6/Alerts] ADD COLUMN labels Utf8;
                        ALTER TABLE [Alerting/V6/Notifications] ADD COLUMN labels Utf8;'

# Check table scheme, change last line for other tables
sudo ydb -e grpcs://solomon-dn.ydb.cloud.yandex.net:2136 \
    -d /global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud.yandex.net \
    scheme describe Config/V2/Service

## GPN

# Add labels to tables
sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    scripting yql -s 'ALTER TABLE [Config/V2/Service] ADD COLUMN labels Utf8;
                        ALTER TABLE [Config/V2/Cluster] ADD COLUMN labels Utf8;
                        ALTER TABLE [Config/V2/Shard] ADD COLUMN labels Utf8;
                        ALTER TABLE [Config/V2/Project] ADD COLUMN labels Utf8;
                        ALTER TABLE [Alerting/V6/Alerts] ADD COLUMN labels Utf8;
                        ALTER TABLE [Alerting/V6/Notifications] ADD COLUMN labels Utf8;'

# Check table scheme, change last line for other tables
sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    scheme describe Config/V2/Service
