#!/bin/bash
# Add "description" Utf8 column to channel, cluster, service and shard.
# Add "shardSettings" Utf8 column to cluster, service and shard.

## TESTING

# Add column (on laptop)
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/development/solomon \
    scripting yql -s 'ALTER TABLE [Alerting/V6/Notifications] ADD COLUMN description Utf8;ALTER TABLE [Config/V2/Cluster] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;ALTER TABLE [Config/V2/Service] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;ALTER TABLE [Config/V2/Shard] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;'

# Check table scheme (on laptop)
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/development/solomon \
    scheme describe Config/V2/Cluster

ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/development/solomon \
    scheme describe Alerting/V6/Notifications

## PRESTABLE

## Add column (on laptop)
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/prestable/solomon \
    scripting yql -s 'ALTER TABLE [Alerting/V6/Notifications] ADD COLUMN description Utf8;ALTER TABLE [Config/V2/Cluster] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;ALTER TABLE [Config/V2/Service] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;ALTER TABLE [Config/V2/Shard] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;'

# Check table scheme (on laptop)
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/prestable/solomon \
    scheme describe Config/V2/Cluster

ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/prestable/solomon \
    scheme describe Alerting/V6/Notifications

## PROD

# Add column (ssh solomon-gateway-myt-00.search.yandex.net)
kikimr db yql --text 'ALTER TABLE [/Kfront/Solomon/Alerting/V6/Notifications] ADD COLUMN description Utf8;ALTER TABLE [/Kfront/Solomon/Config/V2/Cluster] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;ALTER TABLE [/Kfront/Solomon/Config/V2/Service] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;ALTER TABLE [/Kfront/Solomon/Config/V2/Shard] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;'

# Check table scheme (ssh solomon-gateway-myt-00.search.yandex.net)
kikimr db schema describe -d /Kfront/Solomon/Config/V2/Cluster
kikimr db schema describe -d /Kfront/Solomon/Alerting/V6/Notifications

## CLOUD-PREPROD

# Add column (pssh solomon-gateway-00.svc.cloud-preprod.yandex.net)
sudo ydb -e grpcs://solomon-dn.ydb.cloud-preprod.yandex.net:2136 \
    -d /pre-prod_global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud-preprod.yandex.net \
    scripting yql -s 'ALTER TABLE [Alerting/V6/Notifications] ADD COLUMN description Utf8;ALTER TABLE [Config/V2/Cluster] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;ALTER TABLE [Config/V2/Service] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;ALTER TABLE [Config/V2/Shard] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;'

# Check table scheme (pssh solomon-gateway-00.svc.cloud-preprod.yandex.net)
sudo ydb -e grpcs://solomon-dn.ydb.cloud-preprod.yandex.net:2136 \
    -d /pre-prod_global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud-preprod.yandex.net \
    scheme describe Config/V2/Cluster

sudo ydb -e grpcs://solomon-dn.ydb.cloud-preprod.yandex.net:2136 \
    -d /pre-prod_global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud-preprod.yandex.net \
    scheme describe Alerting/V6/Notifications

## CLOUD-PROD

# Add column (pssh solomon-gateway-00.svc.cloud.yandex.net)
sudo ydb -e grpcs://solomon-dn.ydb.cloud.yandex.net:2136 \
    -d /global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud.yandex.net \
    scripting yql -s 'ALTER TABLE [Alerting/V6/Notifications] ADD COLUMN description Utf8;ALTER TABLE [Config/V2/Cluster] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;ALTER TABLE [Config/V2/Service] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;ALTER TABLE [Config/V2/Shard] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;'

# Check table scheme (ppsh solomon-gateway-00.svc.cloud.yandex.net)
sudo ydb -e grpcs://solomon-dn.ydb.cloud.yandex.net:2136 \
    -d /global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud.yandex.net \
    scheme describe Config/V2/Cluster

sudo ydb -e grpcs://solomon-dn.ydb.cloud.yandex.net:2136 \
    -d /global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud.yandex.net \
    scheme describe Alerting/V6/Notifications

## GPN

# Add column (on dyn node solomon-dn-spb99-1.svc.gpn.yandexcloud.net)
sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    scripting yql -s 'ALTER TABLE [Alerting/V6/Notifications] ADD COLUMN description Utf8;ALTER TABLE [Config/V2/Cluster] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;ALTER TABLE [Config/V2/Service] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;ALTER TABLE [Config/V2/Shard] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;'

## Check table schemas (on dyn node solomon-dn-spb99-1.svc.gpn.yandexcloud.net)
sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    scheme describe Config/V2/Cluster

sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    scheme describe Alerting/V6/Notifications
