#!/bin/bash
# Add "proto" String column to v3 dashboards
# Add "globalIdIndex" index to v3 dashboards

## TESTING
# gateway on laptop
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/development/solomon \
    scripting yql -s 'alter table [Config/V3/MonitoringDashboard] ADD COLUMN proto String;'

ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/development/solomon \
    scripting yql -s 'alter table [Config/V3/MonitoringDashboard] ADD COLUMN containerType Utf8;'

ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/development/solomon \
    scripting yql -s 'alter table [Config/V3/MonitoringDashboard] ADD COLUMN localId Utf8;'

ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/development/solomon \
    table index add global \
    --index-name globalIdIndex \
    --columns id \
    Config/V3/MonitoringDashboard

## PRESTABLE
# gateway on laptop
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/prestable/solomon \
    scripting yql -s 'alter table [Config/V3/MonitoringDashboard] ADD COLUMN proto String;'

ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/prestable/solomon \
    scripting yql -s 'alter table [Config/V3/MonitoringDashboard] ADD COLUMN containerType Utf8;'

ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/prestable/solomon \
    scripting yql -s 'alter table [Config/V3/MonitoringDashboard] ADD COLUMN localId Utf8;'


ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/prestable/solomon \
    table index add global \
    --index-name globalIdIndex \
    --columns id \
    Config/V3/MonitoringDashboard

## PROD
# gateway on solomon-gateway-sas-00.search.yandex.net
sudo ydb -e localhost \
    -d /Kfront \
    scripting yql -s 'alter table [Solomon/Config/V3/MonitoringDashboard] ADD COLUMN proto String;'

sudo ydb -e localhost \
    -d /Kfront \
    scripting yql -s 'alter table [Solomon/Config/V3/MonitoringDashboard] ADD COLUMN containerType Utf8;'

sudo ydb -e localhost \
    -d /Kfront \
    scripting yql -s 'alter table [Solomon/Config/V3/MonitoringDashboard] ADD COLUMN localId Utf8;'

sudo ydb -e localhost \
    -d /Kfront \
    table index add global \
    --index-name globalIdIndex \
    --columns id \
    Solomon/Config/V3/MonitoringDashboard

## CLOUD-PREPROD
# gateway on solomon-gateway-00.svc.cloud-preprod.yandex.net
sudo ydb -e grpcs://solomon-dn.ydb.cloud-preprod.yandex.net:2136 \
    -d /pre-prod_global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud-preprod.yandex.net \
    scripting yql -s 'alter table [Config/V3/CloudDashboard] ADD COLUMN proto String;'

sudo ydb -e grpcs://solomon-dn.ydb.cloud-preprod.yandex.net:2136 \
    -d /pre-prod_global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud-preprod.yandex.net \
    scripting yql -s 'alter table [Config/V3/CloudDashboard] ADD COLUMN containerType Utf8;'

sudo ydb -e grpcs://solomon-dn.ydb.cloud-preprod.yandex.net:2136 \
    -d /pre-prod_global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud-preprod.yandex.net \
    scripting yql -s 'alter table [Config/V3/CloudDashboard] ADD COLUMN localId Utf8;'

sudo ydb -e grpcs://solomon-dn.ydb.cloud-preprod.yandex.net:2136 \
    -d /pre-prod_global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud-preprod.yandex.net \
    table index add global \
    --index-name globalIdIndex \
    --columns id \
    Config/V3/CloudDashboard

## CLOUD-PROD
# gateway on solomon-gateway-00.svc.cloud.yandex.net
sudo ydb -e grpcs://solomon-dn.ydb.cloud.yandex.net:2136 \
    -d /global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud.yandex.net \
    scripting yql -s 'alter table [Config/V3/CloudDashboard] ADD COLUMN proto String;'

sudo ydb -e grpcs://solomon-dn.ydb.cloud.yandex.net:2136 \
    -d /global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud.yandex.net \
    scripting yql -s 'alter table [Config/V3/CloudDashboard] ADD COLUMN containerType Utf8;'

sudo ydb -e grpcs://solomon-dn.ydb.cloud.yandex.net:2136 \
    -d /global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud.yandex.net \
    scripting yql -s 'alter table [Config/V3/CloudDashboard] ADD COLUMN localId Utf8;'

sudo ydb -e grpcs://solomon-dn.ydb.cloud.yandex.net:2136 \
    -d /global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud.yandex.net \
    table index add global \
    --index-name globalIdIndex \
    --columns id \
    Config/V3/CloudDashboard

## GPN
# gateway on solomon-gateway-spb99-00.svc.gpn.yandexcloud.net
sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    scripting yql -s 'alter table [Config/V3/CloudDashboard] ADD COLUMN proto String;'

sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    scripting yql -s 'alter table [Config/V3/CloudDashboard] ADD COLUMN containerType Utf8;'

sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    scripting yql -s 'alter table [Config/V3/CloudDashboard] ADD COLUMN localId Utf8;'

sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    table index add global \
    --index-name globalIdIndex \
    --columns id \
    Config/V3/CloudDashboard
