#!/bin/bash
# Add "numPartitions" column to Shard

## TESTING

ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/development/solomon \
    scripting yql -s 'ALTER TABLE [Config/V2/Shard] ADD COLUMN numPartitions Int32;'
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/development/solomon \
    scheme describe Config/V2/Shard

## PRESTABLE

ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/prestable/solomon \
    scripting yql -s 'ALTER TABLE [Config/V2/Shard] ADD COLUMN numPartitions Int32;'
ya ydb -e ydb-ru-prestable.yandex.net:2135 \
    -d /ru-prestable/solomon/prestable/solomon \
    scheme describe Config/V2/Shard

## PROD

# Add column (ssh solomon-gateway-myt-00.search.yandex.net)
kikimr db yql --text 'ALTER TABLE [/Kfront/Solomon/Config/V2/Shard] ADD COLUMN numPartitions Int32;'

# Check table scheme (ssh solomon-gateway-myt-00.search.yandex.net)
kikimr db schema describe -d /Kfront/Solomon/Config/V2/Shard


## CLOUD-PREPROD

# Add column (pssh solomon-gateway-00.svc.cloud-preprod.yandex.net)
sudo ydb -e grpcs://solomon-dn.ydb.cloud-preprod.yandex.net:2136 \
    -d /pre-prod_global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud-preprod.yandex.net \
    scripting yql -s 'ALTER TABLE [Config/V2/Shard] ADD COLUMN numPartitions Int32;'

# Check table scheme (pssh solomon-gateway-00.svc.cloud-preprod.yandex.net)
sudo ydb -e grpcs://solomon-dn.ydb.cloud-preprod.yandex.net:2136 \
    -d /pre-prod_global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud-preprod.yandex.net \
    scheme describe Config/V2/Shard

## CLOUD-PROD

# Add column (pssh solomon-gateway-00.svc.cloud.yandex.net)
sudo ydb -e grpcs://solomon-dn.ydb.cloud.yandex.net:2136 \
    -d /global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud.yandex.net \
    scripting yql -s 'ALTER TABLE [Config/V2/Shard] ADD COLUMN numPartitions Int32;'

# Check table scheme (ppsh solomon-gateway-00.svc.cloud.yandex.net)
sudo ydb -e grpcs://solomon-dn.ydb.cloud.yandex.net:2136 \
    -d /global/solomon \
    --sa-key-file /Berkanavt/keys/solomon/ydb_global_iam.json \
    --iam-endpoint iam.api.cloud.yandex.net \
    scheme describe Config/V2/Shard

## GPN

# Add column (on dyn node solomon-dn-spb99-1.svc.gpn.yandexcloud.net)
sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    scripting yql -s 'ALTER TABLE [Config/V2/Shard] ADD COLUMN numPartitions Int32;'

## Check table schemas (on dyn node solomon-dn-spb99-1.svc.gpn.yandexcloud.net)
sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    scheme describe Config/V2/Shard
