#!/bin/bash
## Add columns (on dyn node solomon-dn-spb99-1.svc.gpn.yandexcloud.net)

# Folders
#   Add columns
sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    scripting yql -s 'ALTER TABLE [Config/V2/Cluster] ADD COLUMN folderId Utf8;ALTER TABLE [Config/V2/Service] ADD COLUMN folderId Utf8;ALTER TABLE [Config/V2/Shard] ADD COLUMN folderId Utf8;ALTER TABLE [Config/V2/ProjectMenu] ADD COLUMN folderId Utf8;ALTER TABLE [Config/V2/Graph] ADD COLUMN folderId Utf8;ALTER TABLE [Config/V2/Dashboard] ADD COLUMN folderId Utf8;'

#   Check table scheme (folderId Utf8 is required)
sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    scheme describe Config/V2/Shard

# Project metric name label
#   Add columns
sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    scripting yql -s 'alter table [Config/V2/Project] ADD COLUMN metricNameLabel Utf8;'

#   Check table scheme (metricNameLabel Utf8 is required)
sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    scheme describe Config/V2/Project

# Description and shard settings
#   Add columns
sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    scripting yql -s 'ALTER TABLE [Alerting/V6/Notifications] ADD COLUMN description Utf8;ALTER TABLE [Config/V2/Cluster] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;ALTER TABLE [Config/V2/Service] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;ALTER TABLE [Config/V2/Shard] ADD COLUMN description Utf8, ADD COLUMN shardSettings Utf8;'

#   Check table scheme (description Utf8, shardSettings Utf8 are required)
sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    scheme describe Config/V2/Cluster

#   Check table scheme (description Utf8 is required)
sudo ydb -e grpc://solomon-dn.ydb.gpn.yandexcloud.net:2135 \
    -d /private-gpn-1_global/solomon \
    scheme describe Alerting/V6/Notifications
