#!/bin/sh -e
#
# Usage:
# sudo ./make_base.sh
# docker import ${DISTRIB_CODENAME}.tgz cr.yandex/crpifv9au2t49ke1mqsg/base-${DISTRIB_CODENAME}:latest
# docker push cr.yandex/crpifv9au2t49ke1mqsg/base-${DISTRIB_CODENAME}:latest

DISTRIB_CODENAME="focal"

DISTRIB_MIRROR="http://mirror.yandex.ru/ubuntu"
PACKAGE_LIST="curl dnsutils ethtool gdb iputils-ping less lsb-release lsof ltrace
	netcat-openbsd net-tools psmisc python3-minimal socat strace tcpdump telnet vim"
DIR="root-${DISTRIB_CODENAME}"
APT_GET="apt-get -yqq --no-install-recommends --allow-unauthenticated"

_exec() {
	echo $* | chroot $DIR sh
}

_sources() {
	echo "deb http://mirror.yandex.ru/ubuntu ${DISTRIB_CODENAME} main restricted universe multiverse" > ${DIR}/etc/apt/sources.list
	echo "deb http://mirror.yandex.ru/ubuntu ${DISTRIB_CODENAME}-security main restricted universe multiverse" >> ${DIR}/etc/apt/sources.list
	echo "deb http://mirror.yandex.ru/ubuntu ${DISTRIB_CODENAME}-updates main restricted universe multiverse" >> ${DIR}/etc/apt/sources.list

	echo "deb http://yandex-cloud.dist.yandex.ru/yandex-cloud stable/all/" > ${DIR}/etc/apt/sources.list.d/yandex-cloud.list
	echo "deb http://yandex-cloud.dist.yandex.ru/yandex-cloud stable/amd64/" >> ${DIR}/etc/apt/sources.list.d/yandex-cloud.list

	echo "deb http://search.dist.yandex.ru/search stable/all/" > ${DIR}/etc/apt/sources.list.d/yandex-search.list
	echo "deb http://search.dist.yandex.ru/search stable/amd64/" >> ${DIR}/etc/apt/sources.list.d/yandex-search.list
	echo "deb http://search.dist.yandex.ru/search unstable/all/" >> ${DIR}/etc/apt/sources.list.d/yandex-search.list
	echo "deb http://search.dist.yandex.ru/search unstable/amd64/" >> ${DIR}/etc/apt/sources.list.d/yandex-search.list

	echo "deb http://common.dist.yandex.ru/common stable/all/" > ${DIR}/etc/apt/sources.list.d/yandex-common.list
	echo "deb http://common.dist.yandex.ru/common stable/amd64/" >> ${DIR}/etc/apt/sources.list.d/yandex-common.list
}

echo "START"
export DEBIAN_FRONTEND=noninteractive LC_ALL=en_US.UTF-8 LANGUAGE=en_US.UTF-8
debootstrap $DISTRIB_CODENAME $DIR $DISTRIB_MIRROR
_sources
echo "64:ff9b::162.213.33.9 keyserver.ubuntu.com" >> ${DIR}/etc/hosts

echo "CONFIGURE"
_exec "LC_ALL=C.UTF-8 locale-gen en_US en_US.UTF-8 && dpkg-reconfigure locales"
_exec "ln -sf /usr/share/zoneinfo/Europe/Moscow /etc/localtime && dpkg-reconfigure tzdata"
_exec "$APT_GET install gnupg"
_exec "apt-key adv --keyserver keyserver.ubuntu.com --recv-keys 7FCD11186050CD1A"

echo "UPDATE"
_exec "$APT_GET update"
_exec "$APT_GET install yandex-internal-root-ca"

echo "UPGRADE"
_exec "$APT_GET dist-upgrade"

echo "INSTALL"
_exec "$APT_GET install $(echo $PACKAGE_LIST)"

echo "CLEANUP"
_exec "$APT_GET clean"
_exec "find /var/lib/apt/lists /var/cache/apt -type f -delete"
_exec "find /var/log -iname *.xz -or -name *.1 -delete"
_exec "find /var/log -type f -exec truncate -s 0 '{}' +"

echo "CREATE ARCHIVE"
tar czf ${DISTRIB_CODENAME}.tgz -C $DIR .
rm -rf $DIR

echo "Now you can push this image to repo:"
echo docker import ${DISTRIB_CODENAME}.tgz cr.yandex/crpifv9au2t49ke1mqsg/base-${DISTRIB_CODENAME}:latest
echo docker push cr.yandex/crpifv9au2t49ke1mqsg/base-${DISTRIB_CODENAME}:latest
