#!/bin/sh

# MYT https://yav.yandex-team.ru/secret/sec-01f241hbsg86m6j3s4xtkhw94t/explore/versions
# SAS https://yav.yandex-team.ru/secret/sec-01f240jdv2gd3aryax8g72e8sk/explore/versions
# VLA https://yav.yandex-team.ru/secret/sec-01f23vagd745sy13y6desac2rm/explore/versions
# MAN https://yav.yandex-team.ru/secret/sec-01f3t6yqprxr95a9jcqb0vdrt4/explore/versions
#
# CoreDNS kubeconfigs: https://yav.yandex-team.ru/secret/sec-01fk3sref5ebpxg1j57zthhbj4/explore/versions

# git clone https://github.com/coredns/coredns
# insert into plugin.cfg
# > kubernetai:github.com/coredns/kubernetai/plugin/kubernetai
# make


BOOTSTRAP_CONF="coredns_bootstrap.yaml"
CLUSTERS="myt man sas vla"


_make_boostrap() {
	cat > $BOOTSTRAP_CONF <<EOF
apiVersion: v1
kind: ServiceAccount
metadata:
  name: coredns
  namespace: kube-system
---
apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRole
metadata:
  labels:
    kubernetes.io/bootstrapping: rbac-defaults
  name: system:coredns
rules:
  - apiGroups: [ "" ]
    resources: [ "endpoints", "services", "pods", "namespaces" ]
    verbs: [ "get", "list", "watch" ]
  - apiGroups: [ "discovery.k8s.io" ]
    resources: [ "endpointslices" ]
    verbs: [ "get", "list", "watch" ]
---
apiVersion: rbac.authorization.k8s.io/v1
kind: ClusterRoleBinding
metadata:
  annotations:
    rbac.authorization.kubernetes.io/autoupdate: "true"
  labels:
    kubernetes.io/bootstrapping: rbac-defaults
  name: system:coredns
roleRef:
  apiGroup: rbac.authorization.k8s.io
  kind: ClusterRole
  name: system:coredns
subjects:
- kind: ServiceAccount
  name: coredns
  namespace: kube-system
EOF
}

_make_core_kube() {
	local _conf=$1 _id=$2 _ep

	_ep="$(awk 'sub(/^\s+server: /, "")' $_conf)"
	TOKENNAME="$(kubectl --kubeconfig $_conf -n kube-system get serviceaccount/coredns -o jsonpath='{.secrets[0].name}')"
	TOKEN="$(kubectl --kubeconfig $_conf -n kube-system get secret $TOKENNAME -o jsonpath='{.data.token}' | base64 -d)"
	CA="$(kubectl --kubeconfig $_conf -n kube-system get configmap kube-root-ca.crt -o jsonpath='{.data.ca\.crt}' | base64 -w 0)"
	CLUSTER_ID="$_id"
	ENDPOINT="$_ep"


	#cat coredns_${CLUSTER_ID}_kube.conf <<EOF
	cat <<EOF
apiVersion: v1
clusters:
- cluster:
    certificate-authority-data: $CA
    server: $ENDPOINT
  name: $CLUSTER_ID
contexts:
- context:
    cluster: $CLUSTER_ID
    user: coredns
  name: coredns@$CLUSTER_ID
current-context: coredns@$CLUSTER_ID
kind: Config
preferences: {}
users:
- name: coredns
  user:
    token: $TOKEN
EOF
}

_make_conf() {
	local _c _clusters _confai

	_clusters="$CLUSTERS"
	for _c in $_clusters ; do
		_confai="${_confai}
    kubernetai ${_c}.local in-addr.arpa ip6.arpa {
        kubeconfig /etc/kubeconfigs/${_c}.conf
        endpoint_pod_names
        ttl 5
        fallthrough in-addr.arpa ip6.arpa
    }"
	done
	cat <<EOF
.:5353 {
    health :8080
    ready :8181
    prometheus :9153
    errors
    loop
    reload
    loadbalance
    dns64
    $_confai
    forward . 2a02:6b8:0:3400::1 2a02:6b8::1:1 {
        policy random
        max_concurrent 1000
    }
    cache {
        success 16384 30 5
        denial 4096 10 5
        prefetch 512 1m 10%
    }
}
EOF
}

_make_conf
#_make_boostrap
#kubectl --kubeconfig $1 apply -f $BOOTSTRAP_CONF
#_make_core_kube $1 $2
