#!/bin/sh -e
#
# https://wiki.yandex-team.ru/cloud/devel/platform-team/infra/skm/#source
# YC_TOKEN=$(ycp --profile israel iam create-token) skm init skm.conf --kms-key-id <ID> --iam-private-endpoint iam.private-api.yandexcloud.co.il:14283 --kms-private-endpoint dpl.kms.private-api.yandexcloud.co.il:8443
# YC_TOKEN=$(ycp --profile israel iam create-token) YAV_TOKEN=$(cat /.config/yav/.token) skm encrypt-md --config skm.conf | awk 'sub(/^    /, "")' > skm.yaml
#

INIT=0
DICT='{
	"pm_cert_id": "b25pfp032gl3hu4je1ra",
	"default_cert_id": "b2551m9q88271398fine",
	"monitoring_api_cert_id": "b25nca6ee20lub9js5dg",
	"monitoring_private_api_cert_id": "b25cmu2879cvc8sf294q"
}'
KEY_ALERTING="c428lrg3bgh2h1gr9ea5"
KEY_FETCHER="c42mqnoklet1s79bvec1"
KEY_GATEWAY="c42nc82uin2g2vebgmj5"
KEY_PM="c423kc77bkca9i663ub9"
KEY_STOCKPILE="c429ojm96trse9sh3a3i"

DIR="$(dirname $0)"
TARGET="$1"


skm_gen() {
	local _key=$1 _config_name=$2 _init_name=$3 _secret_name=$4 _o="" _yav_path="$HOME/.config/yav/.token"

	if [ $INIT = 0 ]; then
		_o="-o"
	fi
	echo $DICT | ${DIR}/skm_generator.py \
		$_o \
		-c ${DIR}/../$_config_name \
		-i ${DIR}/../$_init_name \
		-k $_key \
		-y $_yav_path \
		-e israel \
		--iam iam.private-api.yandexcloud.co.il:14283 \
		--kms dpl.kms.private-api.yandexcloud.co.il:8443 \
		--cert dpl.ycm.private-api.yandexcloud.co.il:8443 \
		--lock cpl.lockbox.private-api.yandexcloud.co.il:8443 \
	> ${DIR}/../$_secret_name
}

if [ -z "$TARGET" -o "$TARGET" = "alerting" ] ; then
	skm_gen $KEY_ALERTING skm_alerting.conf skm_alerting_init.yaml skm_alerting.yaml
fi
if [ -z "$TARGET" -o "$TARGET" = "gateway" ] ; then
	skm_gen $KEY_GATEWAY skm_gateway.conf skm_gateway_init.yaml skm_gateway.yaml
fi
if [ -z "$TARGET" -o "$TARGET" = "pm" ] ; then
	skm_gen $KEY_PM skm_pm.conf skm_pm_init.yaml skm_pm.yaml
fi
if [ -z "$TARGET" -o "$TARGET" = "fetcher" ] ; then
	skm_gen $KEY_FETCHER skm_fetcher.conf skm_fetcher_init.yaml skm_fetcher.yaml
fi
if [ -z "$TARGET" -o "$TARGET" = "stockpile" ] ; then
	skm_gen $KEY_STOCKPILE skm_stockpile.conf skm_stockpile_init.yaml skm_stockpile.yaml
fi
