terraform {
    required_providers {
        ycp = {
            source = "terraform.storage.cloud-preprod.yandex.net/yandex-cloud/ycp"
        }
    }
}

provider "ycp" {
    cloud_id = var.cloud_id
    folder_id = var.infra_folder_id

    ycp_profile = var.env
    // ycp_config  = pathexpand("~/.config/ycp/config.yaml")
    token = data.external.ycp_client_token_generator.result["token"]

    prod = true
}

data "external" "ycp_client_token_generator" {
    program = ["sh", "-c", "ycp --profile israel iam create-token --format json | jq -rM '{token: .iam_token}'"]
    query = {}
}
