resource "ycp_vpc_network" "monitoring-nets" {
    lifecycle {
        prevent_destroy = true
    }
    folder_id = var.infra_folder_id
    name = "monitoring-nets"
}

resource "ycp_vpc_subnet" "monitoring-subnets" {
    for_each = toset(keys(merge(var.ipv4-prefixes, var.ipv6-prefixes)))
    lifecycle {
        prevent_destroy = true
    }

    name = format("monitoring-subnets-%s", each.key)
    network_id = ycp_vpc_network.monitoring-nets.id
    folder_id = var.infra_folder_id
    zone_id = each.key

    v4_cidr_blocks = [
        var.ipv4-prefixes[each.key]
    ]
    v6_cidr_blocks = [
        var.ipv6-prefixes[each.key]
    ]
    // Need to be set, but not enough perms
//    extra_params {
//        hbf_enabled = false
//        rpf_enabled = false
//        export_rts = ["65533:666"]
//        import_rts = ["65533:776"]
//    }
}
