locals {
    balancers = { for name, balancer in var.balancers : "${balancer.group}-${name}-nlb" => {
        services = flatten([
            for _, port in balancer.ports : [
                for addr_idx, address in balancer.addrs : {
                    name = "${port.name}-${addr_idx}"
                    real = port.real
                    virtual = port.virtual
                    address = address
                }
            ]
        ])
        target_group_id = ycp_microcosm_instance_group_instance_group.monitoring-ig["${balancer.group}-0"].load_balancer_state[0].target_group_id
        ip_version = balancer.ip_version
        folder_id = var.groups[balancer.group].folder_id
        health_port = balancer.health_port
        yandex_only = balancer.yandex_only
    } if length(balancer.addrs) > 0 }
}

resource "ycp_load_balancer_network_load_balancer" "monitoring-nlb" {
    lifecycle {
        prevent_destroy = false
    }

    for_each = var.set_nlb ? local.balancers : {}
    folder_id = each.value.folder_id
    name = each.key
    region_id = "il1"
    type = "EXTERNAL"

    dynamic "listener_spec" {
        for_each = each.value.services
        content {
            name = "listener-${each.key}-${listener_spec.value.name}"
            port = listener_spec.value.virtual
            target_port = listener_spec.value.real
            protocol = "TCP"
            external_address_spec {
                ip_version = upper(each.value.ip_version)
                address = listener_spec.value.address
                yandex_only = each.value.yandex_only
            }
        }
    }

    attached_target_group {
        target_group_id = each.value.target_group_id

        health_check {
            name = "check-${each.key}"
            healthy_threshold = 2
            interval = "5s"
            timeout = "2s"
            unhealthy_threshold = 2
            http_options {
                port = each.value.health_port
                path = "/balancer-ping"
            }
        }
    }
}
