// COMMON ================================================

variable "env" {
    type = string
    default = "israel"
}

variable "service_env" {
    type = map(string)
    default = {
        israel = "israel"
    }
}

variable "cloud_id" {
    type = string
    default = "yc.monitoring.cloud"
}

variable "infra_folder_id" {
    type = string
    default = "yc.monitoring.infra"
}

// RESOURCES ================================================

variable "groups" {
    type = map(object({
        subgroups = list(object({
            name = string
            dc_zone = map(string)
            disk_image_id = string
            ig_size = number
            healthcheck_port = number
            healthcheck_path = string
        }))
        folder_id = string
        cores = number
        memory = number
        disk = number
        logs = number
    }))
    default = {
        alerting = {
            subgroups = [{
                name = "alerting-{instance.index}"
                dc_zone = {
                    "a" = "il1-a"
                }
                disk_image_id = "alk1fqrb8un3irk2ekuc"
                ig_size = 4
                healthcheck_port = 4530
                healthcheck_path = "/ok"
            }]
            folder_id = "yc.monitoring.alerting"
            cores = 8
            memory = 16
            disk = 20
            logs = 10
        }
        gateway = {
            subgroups = [{
                name = "gateway-{instance.index}"
                dc_zone = {
                    "a" = "il1-a"
                }
                disk_image_id = "alkf9vq9t5tdof7q1j51"
                ig_size = 4
                healthcheck_port = 4540
                healthcheck_path = ""
            }]
            folder_id = "yc.monitoring.gateway"
            cores = 16
            memory = 32
            disk = 30
            logs = 10
        }
        pm = {
            subgroups = [{
                name = "pm-{instance.index}"
                dc_zone = {
                    "a" = "il1-a"
                }
                disk_image_id = "alkamtom261kl143pf1c"
                ig_size = 4
                healthcheck_port = 4580
                healthcheck_path = ""
            }]
            folder_id = "yc.monitoring.pm"
            cores = 2
            memory = 8
            disk = 30
            logs = 10
        }
        fetcher = {
            subgroups = [{
                name = "core-a-{instance.index}"
                dc_zone = {
                    "a" = "il1-a"
                }
                disk_image_id = "alk64atkl5kp1ehare0e"
                ig_size = 4
                healthcheck_port = 4510
                healthcheck_path = ""
            },{
                name = "core-b-{instance.index}"
                dc_zone = {
                    "b" = "il1-a"
                }
                disk_image_id = "alk64atkl5kp1ehare0e"
                ig_size = 4
                healthcheck_port = 4510
                healthcheck_path = ""
            }]
            folder_id = "yc.monitoring.fetcher"
            cores = 16
            memory = 64
            disk = 30
            logs = 10
        }
        stockpile = {
            subgroups = [{
                name = "stockpile-a-{instance.index}"
                dc_zone = {
                    "a" = "il1-a"
                }
                disk_image_id = "alkip5u90qdvqg00b5bu"
                ig_size = 4
                healthcheck_port = 4500
                healthcheck_path = ""
            },{
                name = "stockpile-b-{instance.index}"
                dc_zone = {
                    "b" = "il1-a"
                }
                disk_image_id = "alkip5u90qdvqg00b5bu"
                ig_size = 4
                healthcheck_port = 4500
                healthcheck_path = ""
            }]
            folder_id = "yc.monitoring.stockpile"
            cores = 16
            memory = 64
            disk = 30
            logs = 10
        }
    }
}

variable "public-keys" {
    type = map(string)
    default = {
        "images-sa" = <<EOF
-----BEGIN PUBLIC KEY-----
MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA4AUyVFz02UIhycq73o5H
Z+sZjGWcWsdk4M0SxYNyD2xIuI0o3QIkHX8tvOyWDOEFTXxkDho3sL7JRQpq/J2p
66ODsuF4GPq1qQJncDQ8d9EZRCz8JMLqiJfqK4ODuO+Wd0hfho6LImjSHY/NIbwW
14kQBbsaL2XhP6nuAyEASDI7sHULfkYLqo5D9ApPR4ytKMxURn8Ach7IJDCrVRa3
8ob6aetRNZ5Mh6jVJoJ1zUa9Japc1JwhBOoZ9MNsMa9p+OZZX7AP5O/pzksQdu12
WzhkrbsViL+SKlT17hzxMG/XDe3yOmg8b33jLAyLxgGTjc17PaLpYTWVd0CArQPl
4kPMnCInPhReAfxuRizaghcBK6Sol1ztTswwDuASa5hGmFboloSda1rE3IMPCNjN
NmG7lQTirwuTtCtSrRBALHi+ufjwzkcX/QPZ+WBec+19l3OqODw1H956YmGPliH7
MfuM163iN99l+e3ceKA6sQ6AMm25p3pG6E9J+ZCnb/HlXIo20i8xhluSIFTyObr4
xGvUTJ5jG3f4QSkGYkXrCpeO4EZK5696mMIdQjYeKwpXOBNdeBz0hR09iyKU1sAY
5J5tYrUu4Nd6x/lpVrwRDDY7lbE5lSRgahqu18Tq9+fDUgVISIXT4jUtBgp32hB5
5dNm/ni28miFrHHXoj0tcd0CAwEAAQ==
-----END PUBLIC KEY-----
EOF
        "gateway-sa" = <<EOF
-----BEGIN PUBLIC KEY-----
MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAvWQZi8yhyrlGdD2gOgvo
Ihd4gS3xKekra6C1Mbxcr6HMPP1JASEu6nPesDwIh5ve86flMK2MJeMlNs+sx0qj
zNj7WkDDm32y+//647Dwi0l5XpzVEEZluCUPbqhzU6kU8dkPUMfaPN1PFI7wy6Xh
DJS4/JdZhm0v3oYPtz5bbxiqOX2yIl8wg3xJK3W2WtnDaJwOpxEZrZQRmC+i6YnE
xORm4pgz2ah0qU6bqLZ2CPbPeIAuXLhPDp+pwmjMvLEMQ+WTAbwfOdm+tzjDjw51
Sqh4sy53Y/bqOLX3+tXfW9+bhiapE5+yTOt8aOfNGkc1S+yocuElrN2QW6g6ZE1n
ZKQkf222vGuz+yFUv+i/8MWGzRsLkwr0gYnLpjzKA+ydWbODnCI5zdhgbjzWunx0
pmPaNkijeMMoo7MKT1DffqHmfo4Mdo9MOJqGW7FSJDu9IJExv53CwvwAcm8NUOfO
ecsvtVZl/qILA25J71ec7agt9Ocizd2ocvr5pwaTjhe5K3zsoX0tW+npHK3pdaCG
HWsFeOwzzVSs0y/xJHlYAGbnDaaWwtdnH5sQ0gYOXg/8kjjC/UWQTBLjut5MXLad
ebCDAMrGDsL+fcy3g8LGno+A8gPvCyh/465RKyvwFcj4m2NbzLZJG8EVOMK5R81w
3xQiOlQ6XRXkyVLuoSa7dt8CAwEAAQ==
-----END PUBLIC KEY-----
EOF
        "alerting-sa" = <<EOF
-----BEGIN PUBLIC KEY-----
MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAuLdzrFO56DoBfBf5x8ux
+TmRjYWD+ZYfm6p1++EWJGyWUGOPbUasjN0u5mwECDng7MGpt5OQm50Jo5zKYPCv
H6HKSA/Mfim42rg8kK5UCBwQ5hOWHKgdWs1kGowQyBcAUvw4DF1hdIcV2hezPMJq
xZywaLYWV9wgdybtqumSwxUP04eJvJ/SLm+PVKaUD5zPGLLgrFFjS+VsiRGasg9D
y31GlB3E5H9+6W6/V9y3/EU1OyZ8nlBXvsQJI3UMRuNOmA+iiXE0GqGSxow8bA67
JhF01ESwdGnkDmjTjuBmK3TOGbA5EWwHigqLvMK7wwI0OIyJ37KntKxJjHTk4t7+
vG53PAdwvfRWuSF7mhrEgH0LsDHqAcSECGnkIufus4VPdggoQk6fzrtp/d7AvEYL
T6/1mJqJyeF7J2ioAPxkW/s7u2Ri578aU8/aubXb1oiPm5qPG6YglGTv9irX+uUE
ysHklfquHf7x0znS1k/iWZPrkjrgjm9tetbmcBvZeLVI/lJZxMa3vOgVqpBpbu8Y
p+FMhRyZ464qANGySi97dT2WSknJH43LUdlDG0riaHI6G0c6X5NTe2uB/ILzA51s
Wz6z9prHCHxO99HKVGTrlGOoAxGRXuT1nNM1Q9gaE+zQhqT0OeYCxF8IrJd7rBvj
9QJCB9KfrdKWAmruNM1iyVkCAwEAAQ==
-----END PUBLIC KEY-----
EOF
        "pm-sa" = <<EOF
-----BEGIN PUBLIC KEY-----
MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAp0F11GWpRfTMHZ47V9NY
EK7FTWfQRbRY2nfhfowPhGxX749jXm23tzhV0sXQk5Q5co6KUUMySEZLqUdG1T8J
xY4TdUYnnRHzxTNFBr/TOCkkboNf8M7Jlggjw5f0DMIM8yrjDSYt9sqj1dN7cwBB
4F/s/1vllEyjBLEJ9qlGxO2fCSJgand3KZmbAoilF1crYCAxJFeT4wsKKFRFgMYa
LeWB7cbF33yH0d8yMhUSBFD7QelhZou3HQncDuaDsPfDCSwdPzNUxcKwCcYm95Vk
P/4RfkFqZAhp60IvKhdP/mKGj7GCk5bUQR9sPulem/BEXDo9Mo+JhAsJjJT4ft8J
BAIeiFUz82xmK55vmep2fGxDkVQ7eEQwXLaglrEvRt1h9psjZf/9kndM2ZB0j0V9
j5JRNyPKb29iBVoHzX8mg76SO/zdDgh0e4o2ue6xp/bRdH4ivIKaKYEL1s2XPRxA
rGLdPg+bnPBm3Gx9j+ryEy8XfC4WvVFbE3incd7PtXkluvkCxlIEPQR7NQ+snWLz
UGQ8UPz9HvoStm/NkQ7sTWlqvuerW0zm+xR1ziN243Jp+cNG+ixCCyDBiAoqyKyV
4jtDEqJo8RynILAMO3VgFxFdxuqdsNfUebuUBPw2a7mvIlq3ewg+E6Mv73VDgOAz
rKcFvMiDy8S9TxIYdrcCJ80CAwEAAQ==
-----END PUBLIC KEY-----
EOF
        "fetcher-sa" = <<EOF
-----BEGIN PUBLIC KEY-----
MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAncT7yaLG5GG2tuf8Wu3o
EebMkczeEppjc/GsBZIADxBL9QWS3hWaabtkpuMsk7iEZMWC5wCSSuICdZys/AWQ
9xTL5CTkJwhlOvgKHqVZjql6/bZZT/7vmm62KsUUhB16nutBC296caE2SFtyOork
CsZnfpx4OthjKy7rqD7Tdk0fnrV6zRKtFYxFffR5S5M+/Q1Yh71HTj6GcqKy2Krs
BVJjt+h0JDxzxelbFgYcFLeiVPlm3lqyk6r/qQr2RPZ4NWgfCUSodQFMrqEPoizP
OtNk52G/IteBlFALEWQa/o8Toi6kw/uIN+E6aXFG3uQFTcXhDi8A9JM+XNBb+oUF
sAzpkGCQuJb2CtGKoVCd44+CmbIoWwBPKrgsXnGwv8jJnC2VtrmBCFVHkIagxhZE
x+ABqzerL1CgYKHRiQ3nNYF0sho2GgYMePERC5Z1Y4L2HIEX16VNVXXAk1SZ8Y41
fh+aFil8sCa3Z8FtC2atWwz1yzDlFHAsSt/nVvhJC7szrBRR+UpN82v4pQCW6ll+
K9XgNE3b9TQU1RVDU+uFaiBhEl0WnuO/A5eAtNIa8JHMrX2Df+PRw3D9P6Tbn/+M
G/Vu7Uhv7V++M9EKvYvj2YrpO5AKpQpe1w9luDezbAW7FggGsPJZLHSM0h85/JOF
XCiFs/pmRTu44cfLYZEy0sMCAwEAAQ==
-----END PUBLIC KEY-----
EOF
        "ydb-sa" = <<EOF
-----BEGIN PUBLIC KEY-----
MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEApp79ntxbvO/VchfkEX3q
g6W1LgNMZzFf/k83fxQs+r0yXHI0ZJIx4lhS3lld1VxaWJ5t/p/OXv6zVhECQ4ip
BC7R6oRC5k3JLal8PY8Qu1Q2202RRts1v7DASir/PfG/14KPeOxcyVQ+LrbwBAjL
spKpEviTAt5aNg1DBM8wOP+Io86eUJ49jSzaQPkIE/ERT6iA6J7UruCrL88vPfGe
pU6MoNnzqQ/LZXr53d4wlw7lGvyn9lFlqIcTLAj9kU6xf6s6VFxlYasgSSdsabvo
N8ermHuwd6RomtdwImMsqh7b9MGqZjLb/gIG26ZbMS7Zgc+RwVEGlb/5p2aXW+/W
L/432NrOgmjUc9+3Hv9eng+/9xRhZ1bscYamYIdzKNI5C7NX46FHUEKT9zHkQ+bn
d4+A8XQ6H+YTSdUmDXsTUJU0sKv8SwBEU5HPynUxxCn5dgRyDC6pBA7qT2S7UDni
b/HBnlVSPHQ49UBIMh29czuHtD4k3ZRKzvPhfG/UOwh+4dvmysI8QOEvbQQV8kHa
aQDQtl99TUek64YZFPgHb3QewtgW5pOPbP/XOjq4K+ar0JojBEMmbTmRwHt8pkox
/pkeaV/6svDk06wzeJYu16pWn9JJDBrtEjpQpCa0biyumX2BkJkTgzRRPfbs31UU
pUqjl+GkJ5LyWdodQZweXUMCAwEAAQ==
-----END PUBLIC KEY-----
EOF
    }
}

variable "logs_disk_id" {
    type = string
    default = "logs-disk"
}

// NET ================================================

variable "certs" {
    //
    // for GlobalSign certs
    // https://wiki.yandex-team.ru/cloud/devel/certificate-manager/ycm-internal-providers/#kakvypisatglobalsignsertifikat
    //
    type = map(object({
        domains = list(string)
        cert_provider = string
        challenge_type = string
        folder_id = string
    }))
    default = {
        solomon = {
            domains = ["solomon.yandexcloud.co.il"]
            cert_provider = "INTERNAL_CA"
            challenge_type = "CHALLENGE_TYPE_UNSPECIFIED"
            folder_id = "yc.monitoring.gateway"
        }
        pm = {
            domains = ["pm.mon.yandexcloud.co.il"]
            cert_provider = "INTERNAL_CA"
            challenge_type = "CHALLENGE_TYPE_UNSPECIFIED"
            folder_id = "yc.monitoring.pm"
        }
        monitoring-api = {
            domains = ["monitoring.api.cloudil.com"]
            cert_provider = "LETS_ENCRYPT"
            challenge_type = "DNS"
            folder_id = "yc.monitoring.gateway"
        }
        monitoring-private-api = {
            domains = ["monitoring.private-api.yandexcloud.co.il"]
            cert_provider = "INTERNAL_CA"
            challenge_type = "CHALLENGE_TYPE_UNSPECIFIED"
            folder_id = "yc.monitoring.gateway"
        }
    }
}

variable "underlay_fqdn" {
    type = string
    default = "under.mon.yandexcloud.co.il"
}

variable "set_nlb" {
    type = bool
    default = true
}

variable "balancers" {
    type = map(object({
        ports = list(object({
            name = string
            real = number
            virtual = number
        }))
        addrs = list(string)
        ip_version = string
        group = string
        health_port = number
        yandex_only = bool
    }))
    default = {
        solomon = {
            ports = [{
                name = "http"
                real = 80
                virtual = 80
            },{
                name = "https"
                real = 443
                virtual = 443
            }]
            ip_version = "ipv6"
            addrs = ["2a11:f740:1:1::145"]
            group = "gateway"
            health_port = 80
            // set to false only to make tf happy (it tries to change to true each execution): looks like api is not acknowledging this setting
            yandex_only = false
        }
        manager = {
            ports = [{
                name = "http"
                real = 80
                virtual = 80
            },{
                name = "https"
                real = 443
                virtual = 443
            }]
            ip_version = "ipv6"
            addrs = ["2a11:f740:1:1::98"]
            group = "pm"
            health_port = 80
            // set to false only to make tf happy (it tries to change to true each execution): looks like api is not acknowledging this setting
            yandex_only = false
        }
        monitoring-api-v4 = {
            ports = [{
                name = "https"
                real = 4443
                virtual = 443
            },{
                name = "http"
                real = 4480
                virtual = 4480
            }]
            ip_version = "ipv4"
            addrs = ["46.243.144.222"]
            group = "gateway"
            health_port = 80
            yandex_only = false
        }
        monitoring-api-v6 = {
            ports = [{
                name = "https"
                real = 4443
                virtual = 443
            },{
                name = "http"
                real = 4480
                virtual = 4480
            }]
            ip_version = "ipv6"
            addrs = ["2a11:f740:2:1::2e7"]
            group = "gateway"
            health_port = 80
            yandex_only = false
        }
    }
}

variable "ipv4-prefixes" {
    type = map(string)
    default = {
        il1-a = "172.16.0.0/24" // CLOUD-93131
    }
}

variable "ipv6-prefixes" {
    type = map(string)
    default = {
        il1-a = "2a11:f740:1:0:9000:1f::/96" // CLOUD-95673
    }
}

// DNS ================================================

variable "dns_zone_id" {
    type = string
    default = "yc.bootstrap.monitoring"
}

variable "dns_zone" {
    type = map(string)
    default = {
        israel = "mon.yandexcloud.co.il"
    }
}

variable "set_ptr" {
    type = bool
    default = true
}
