#!/bin/sh

CMD="ycp --profile preprod"
FOLDERS="
	yc.monitoring.gateway
	yc.monitoring.alerting
	yc.monitoring.pm
	yc.monitoring.fetcher
	yc.monitoring.stockpile
"
# FOLDERS="$($CMD resource-manager folder list --cloud-id yc.monitoring.cloud --format json | jq -r '.[] | .id')"

if [ -n "$1" ]; then
	FOLDERS="yc.monitoring.$1"
fi

for F in $FOLDERS ; do
	IG_JSON="$($CMD microcosm instance-group list --folder-id $F --format json)"

	BAD_IG_IDS="$(echo "$IG_JSON" | jq -r '.[] | select(.scale_policy.fixed_scale.size != .managed_instance_statuses.RUNNING_ACTUAL) | .id')"
	if [ -n "$BAD_IG_IDS" ] ; then
		for ID in $BAD_IG_IDS ; do
			echo "Group id=$ID in $F is not OK!"
		done
		echo "Not cleaning folder $F"
		continue
	fi

	USED_IMAGE_IDS="$(echo "$IG_JSON" | jq -r '[.[] | .instance_template.boot_disk_spec.disk_spec.image_id] | unique | .[]')"
	ALL_IMAGE_IDS="$($CMD compute image list --folder-id $F --format json | jq -r '.[].id')"
	for ID in $ALL_IMAGE_IDS ; do
		DELETE=1
		for U in $USED_IMAGE_IDS ; do
			if [ "$U" = "$ID" ] ; then
				DELETE=0
			fi
		done
		if [ $DELETE -eq 1 ] ; then
			echo "Deleting image_id=$ID in $F: it is not used!"
			$CMD compute image delete $ID
		else
			echo "Not deleting image_id=$ID in $F: it is still in use!"
		fi
	done
done
