#!/bin/sh

CMD="ycp --profile preprod"
FOLDERS="yc.monitoring.$1"
# FOLDERS="$($CMD resource-manager folder list --cloud-id yc.monitoring.cloud --format json | jq -r '.[] | .id')"

if [ -z "$1" ]; then
	echo "Usage: $0 (alerting|gateway|pm|fetcher|stockpile)"
	exit 1
fi

for F in $FOLDERS ; do
	IG_JSON="$($CMD compute instance list --folder-id $F --format json)"
	for ID in $(echo $IG_JSON | jq -r '.[].id') ; do 
		FQDN="$(echo $IG_JSON | jq -r '.[] | select(.id == "'$ID'") | .fqdn')"
		IMG_IDS="$($CMD compute instance list-disks --id $ID --format json | jq -r '.[] | select(has("source_image_id")) | .source_image_id')"
		echo "$FQDN - $IMG_IDS"
	done
done
