#!/bin/sh

CMD="ycp --profile preprod"
FOLDERS="yc.monitoring.$1"
# FOLDERS="$($CMD resource-manager folder list --cloud-id yc.monitoring.cloud --format json | jq -r '.[] | .id')"

if [ -z "$1" ]; then
	echo "Usage: $0 (alerting|gateway|pm|fetcher|stockpile) [pause|resume|toggle|check]"
	exit 1
fi
case "$2" in
	pause|resume|toggle|check)
		ACTION="$2"
		;;
	"")
		ACTION="check"
		;;
	*)
		echo "Unknown action: $2"
		exit 1
		;;
esac

for F in $FOLDERS ; do
	IG_JSON="$($CMD microcosm instance-group list --folder-id $F --format json)"
	for ID in $(echo $IG_JSON | jq -r '.[].id') ; do 
		IG_ID_JSON="$(echo $IG_JSON | jq -r '.[] | select(.id == "'$ID'")')"
		NAME="$(echo $IG_ID_JSON | jq -r '.name')"
		FQDN="$(echo $IG_ID_JSON | jq -r '.instance_template.fqdn')"
		STATUS="$(echo $IG_ID_JSON | jq -r '.status')"
		STATE="$(echo $IG_ID_JSON | jq -cr '[.managed_instance_statuses | to_entries[] | select((.value | tonumber) > 0)] | from_entries')"
		echo "Checking $NAME $STATUS $FQDN $STATE"

		if [ "$STATUS" = "ACTIVE" ] && [ "$ACTION" = "toggle" -o "$ACTION" = "pause" ] ; then
			echo "PAUSING $NAME ..."
			NEW_STATUS="$($CMD microcosm instance-group pause-processes --id $ID --format json | jq -r '.status')"
			echo "New status for $NAME = $NEW_STATUS"
		elif [ "$STATUS" = "PAUSED" ] && [ "$ACTION" = "toggle" -o "$ACTION" = "resume" ] ; then
			echo "RESUMING $NAME ..."
			NEW_STATUS="$($CMD microcosm instance-group resume-processes --id $ID --format json | jq -r '.status')"
			echo "New status for $NAME = $NEW_STATUS"
		fi
	done
done
