#!/bin/sh -e
#
# https://wiki.yandex-team.ru/cloud/devel/platform-team/infra/skm/#source
# YC_TOKEN=$(ycp --profile preprod iam create-token) skm init skm.conf --kms-key-id <ID>
# YC_TOKEN=$(ycp --profile preprod iam create-token) YAV_TOKEN=$(cat /.config/yav/.token) skm encrypt-md --config skm.conf | awk 'sub(/^    /, "")' > skm.yaml
#

FORCE_INIT=0
DICT='{
	"pm_cert_id": "fd30nosb86mqqi8fhk72",
	"default_cert_id": "fd32cj1s8bjis14qs1p6",
	"monitoring_api_cert_id": "fd3ir1lodktgq9ahlo8h",
	"monitoring_private_api_cert_id": "fd3317keqnq3gh06tvup"
}'
KEY_ALERTING="e10mvtsbiar3a8fgbruu"
KEY_FETCHER="e10ikhdso1lljq2k9ujs"
KEY_GATEWAY="e10esni3odlc5putn9t8"
KEY_PM="e10rccrbmle8bd1g46te"
KEY_STOCKPILE="e10qfucq751sbeo7031s"

DIR="$(dirname $0)"
TARGET="$1"


skm_gen() {
	local _key=$1 _config_name=$2 _init_name=$3 _secret_name=$4 _f="" _yav_path="$HOME/.config/yav/.token"

	if [ $FORCE_INIT = 1 ]; then
		_o="-f"
	fi
	echo $DICT | ${DIR}/skm_generator.py \
		$_f \
		-c ${DIR}/../$_config_name \
		-i ${DIR}/../$_init_name \
		-k $_key \
		-y $_yav_path \
		-e preprod \
		--api api.cloud-preprod.yandex.net:443 \
	> ${DIR}/../$_secret_name
}

if [ -z "$TARGET" -o "$TARGET" = "alerting" ] ; then
	skm_gen $KEY_ALERTING skm_alerting.conf skm_alerting_init.yaml skm_alerting.yaml
fi
if [ -z "$TARGET" -o "$TARGET" = "gateway" ] ; then
	skm_gen $KEY_GATEWAY skm_gateway.conf skm_gateway_init.yaml skm_gateway.yaml
fi
if [ -z "$TARGET" -o "$TARGET" = "pm" ] ; then
	skm_gen $KEY_PM skm_pm.conf skm_pm_init.yaml skm_pm.yaml
fi
if [ -z "$TARGET" -o "$TARGET" = "fetcher" ] ; then
	skm_gen $KEY_FETCHER skm_fetcher.conf skm_fetcher_init.yaml skm_fetcher.yaml
fi
if [ -z "$TARGET" -o "$TARGET" = "stockpile" ] ; then
	skm_gen $KEY_STOCKPILE skm_stockpile.conf skm_stockpile_init.yaml skm_stockpile.yaml
fi
