#!/bin/sh

CMD="ycp --profile preprod"
if [ -z "$1" -o -z "$2" ]; then
	echo "Usage: $0 (alerting|gateway|pm|fetcher|stockpile) <name>"
	exit 1
fi
FOLDER="yc.monitoring.$1"

ID="$($CMD compute instance list --folder-id $FOLDER --format json | jq -r --arg NAME "$2" '.[] | select(.name == $NAME) | .id')"
if [ -z "$ID" ] ; then
	echo "No id for name=$2"
	exit 1
fi

$CMD compute instance get-serial-port-output --id $ID --format json | jq -r '.contents' | sed 's/\\r\\n/\n/g; s/^"//'
