locals {
    ycp_profile = var.ycp_profile[var.env]
}

terraform {
    required_providers {
        ycp = {
            source = "terraform.storage.cloud-preprod.yandex.net/yandex-cloud/ycp"
        }
    }
}

provider "ycp" {
    cloud_id = var.cloud_id
    folder_id = var.infra_folder_id

    ycp_profile = local.ycp_profile
    // ycp_config  = pathexpand("~/.config/ycp/config.yaml")
    token = data.external.ycp_client_token_generator.result["token"]

    prod = true
}

data "external" "ycp_client_token_generator" {
    program = ["sh", "-c", "ycp --profile ${local.ycp_profile} iam create-token --format json | jq -rM '{token: .iam_token}'"]
    query = {}
}
