locals {
    ipv6_prefixes = {
        for name, prefix in var.ipv6_prefixes[var.env].subnets : name => cidrsubnet(
            cidrsubnet(prefix, var.ipv6_prefixes[var.env].netmask, var.ipv6_prefixes[var.env].project_id),
            var.ipv6_prefixes[var.env].new_bits,
            0
        )
    }
}

resource "ycp_vpc_network" "monitoring-nets" {
    lifecycle {
        prevent_destroy = true
    }
    folder_id = var.infra_folder_id
    name = "monitoring-nets"
}

resource "ycp_vpc_subnet" "monitoring-subnets" {
    for_each = toset(keys(merge(var.ipv4_prefixes, local.ipv6_prefixes)))
    lifecycle {
        prevent_destroy = true
    }

    name = format("monitoring-subnets-%s", each.key)
    network_id = ycp_vpc_network.monitoring-nets.id
    folder_id = var.infra_folder_id
    zone_id = each.key

    v4_cidr_blocks = [
        var.ipv4_prefixes[each.key]
    ]
    v6_cidr_blocks = [
        local.ipv6_prefixes[each.key]
    ]
    // Need to be set, but not enough perms
//    extra_params {
//        hbf_enabled = false
//        rpf_enabled = false
//        export_rts = ["65533:666"]
//        import_rts = ["65533:776"]
//    }
}
