// COMMON ================================================

variable "env" {
    type = string
    default = "preprod"
}

variable "service_env" {
    type = map(string)
    default = {
        preprod = "cloud-preprod"
    }
}

variable "ycp_profile" {
    type = map(string)
    default = {
        preprod = "inpreprod"
    }
}

variable "cloud_id" {
    type = string
    default = "yc.monitoring.cloud"
}

variable "infra_folder_id" {
    type = string
    default = "yc.monitoring.infra"
}

// RESOURCES ================================================

variable "groups" {
    type = map(object({
        subgroups = list(object({
            name = string
            dc_zone = map(string)
            disk_image_id = string
            ig_size = number
            healthcheck_port = number
            healthcheck_path = string
        }))
        folder_id = string
        cores = number
        memory = number
        disk = number
        logs = number
    }))
    default = {
        alerting = {
            subgroups = [{
                name = "alerting-{instance.index}"
                dc_zone = {
                    "a" = "ru-central1-a"
                    "b" = "ru-central1-b"
                    "c" = "ru-central1-c"
                }
                disk_image_id = ""
                ig_size = 3
                healthcheck_port = 4530
                healthcheck_path = "/ok"
            }]
            folder_id = "yc.monitoring.alerting"
            cores = 8
            memory = 16
            disk = 20
            logs = 10
        }
        gateway = {
            subgroups = [{
                name = "gateway-{instance.index}"
                dc_zone = {
                    "a" = "ru-central1-a"
                    "b" = "ru-central1-b"
                    "c" = "ru-central1-c"
                }
                disk_image_id = "fdvouuiluqkhfgek5vtd"
                ig_size = 3
                healthcheck_port = 4540
                healthcheck_path = ""
            }]
            folder_id = "yc.monitoring.gateway"
            cores = 16
            memory = 32
            disk = 30
            logs = 10
        }
        pm = {
            subgroups = [{
                name = "pm-{instance.index}"
                dc_zone = {
                    "a" = "ru-central1-a"
                    "b" = "ru-central1-b"
                    "c" = "ru-central1-c"
                }
                disk_image_id = ""
                ig_size = 3
                healthcheck_port = 4580
                healthcheck_path = ""
            }]
            folder_id = "yc.monitoring.pm"
            cores = 2
            memory = 8
            disk = 30
            logs = 10
        }
        fetcher = {
            subgroups = [{
                name = "core-a-{instance.index}"
                dc_zone = {
                    "a" = "ru-central1-a"
                }
                disk_image_id = ""
                ig_size = 8
                healthcheck_port = 4510
                healthcheck_path = ""
            },{
                name = "core-b-{instance.index}"
                dc_zone = {
                    "b" = "ru-central1-b"
                }
                disk_image_id = ""
                ig_size = 8
                healthcheck_port = 4510
                healthcheck_path = ""
            }]
            folder_id = "yc.monitoring.fetcher"
            cores = 16
            memory = 32
            disk = 30
            logs = 10
        }
        stockpile = {
            subgroups = [{
                name = "stockpile-a-{instance.index}"
                dc_zone = {
                    "a" = "ru-central1-a"
                }
                disk_image_id = ""
                ig_size = 8
                healthcheck_port = 4500
                healthcheck_path = ""
            },{
                name = "stockpile-b-{instance.index}"
                dc_zone = {
                    "b" = "ru-central1-b"
                }
                disk_image_id = ""
                ig_size = 8
                healthcheck_port = 4500
                healthcheck_path = ""
            }]
            folder_id = "yc.monitoring.stockpile"
            cores = 8
            memory = 48
            disk = 30
            logs = 10
        }
    }
}

variable "public-keys" {
    type = map(string)
    default = {
        "images-sa" = <<EOF
-----BEGIN PUBLIC KEY-----
MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA0COs8ua2/X+vPwQBquyw
DQ0DafXkiGwMNcgqP7bn4/9y9VokJ8u+Vn21uYuAby3bfDBfq2U0b7Jn7erJh/Tt
Mdk2dC7pLIRlbi2/TTi7lZICYdCSUMPaN85XU2oQLgAXuN+Ezai9gSheUj502iKh
noHOshsihjV3tHx9NZ1VLs01tAjtd+2U3P7JWBVRahmazUZYlzOWxq2uX5b+j8gl
rJRzeqlFv+/h1gH/vJq3IwofbFKvMDB7Hb9g7tRpshrOoNpWEouNs4auXvucm2vW
CgP6xcrzO+Pl9QSKb8Z8Cvs/cPxtYOvmWEEQ/ATkkFSgQttE7WZCTf8xQKuTdQdr
cwYnlgKRZVGeypo7no/39Q6GZBS0eEH0PXwKDKFCFzu+T3+TqU6lRMz8n8jPN8of
09TTgBRhd3lMXhhkJfjrgtNkkAUccH0FJQ09QItK/PJBE4q3Ut10etdjNs8L/gBt
cFWQ3P9viYV+QkMFpOVf0lAv1xOyoRmPTUcx3EgDPEAmj0tPQaNOf0Aq1O6tgOv+
ahOg/VpWd4upoteu534RsYEu/L+8DdIrP7A9WRJ5ooRxmnZVpm4cIhxTJvBtTVUe
sISA6B1sXsoD6z8pw7mkZSBgblxQ6c4tjKVoXFhrBEXI/90e+hcR9XZmL7T01FXy
vwiEzFVQqZVGk/kR/STI93cCAwEAAQ==
-----END PUBLIC KEY-----
EOF
        "gateway-sa" = <<EOF
-----BEGIN PUBLIC KEY-----
MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA5JtrhhhZAH/40FPwO8Kt
LJAEAzk9+eK4c48XbNux5h5ZyUW6EESh5qeuYPKtcWNVxapc1Ul0jIXOk/y2FxlM
f9u5TpB1NDhYWudDzI/gx9kDJwsbFRXSDGJb9fuFjx/AOmhF04kFsftKsGOhy5VG
i4iL3XgCF2C4PG4HO6j0H47aJMh/v+v97X3tZYZGDSwsnS5713sC9qnck/vsXefw
352HFPx80QeRzDUHlkIeaFnaO9LPqt34cjMh60xNGyytDbNBmLlCy4cshkmmqIuy
dnf2UVJE3r6qtCJzVEDLJ1lIxIC9msGrJcBdwDXirtc9gw9/T8uTNBGo1X2rhtZ6
4O32SV2odHgREtbzOTgHOpknhKzOVcXkXs6IUsubMENJX1NH6FvXg5JyLBKZtpQs
JvaypCWBCJPp4KnBUJdGvzqGeqObpWQZ4uWNeavNBM9zlDcxcNU9CgFEoNvEfPP8
urwU0dSpA0lOwDtFka4Yv7hM6dQDjXKhatd8oT/ltyKd+fFdlTSBH98m7LDkP1jx
D/ZBjQlR1Hy+9yluG2y/VW6QMjbq4itFb5eR+8udVnH2IhnL48C49PnRcSM/rHMr
4jiA+4O4+IGA1P3xpFF5H7RQQeEtrz54a6K+w6WSZVB4oZ51E94j8JfB++no4Woy
ClHA5IZzO4l3LHgtq+XhuBMCAwEAAQ==
-----END PUBLIC KEY-----
EOF
        "alerting-sa" = <<EOF
-----BEGIN PUBLIC KEY-----
MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAzFR1B2btiFO93Y4sZ/Rp
t6RAHiEV/N6hXihA5RUzvGaaRhd56ngrq18YeFT0VTrZmwA7kwoz6xpJVIT5aejW
ycJFpW8hGftB1ZIBARlwcPu8DeMQ5zTbpW2Tbr2jG34hvnjyhxGbFg3hIuQ3H+4m
EnH5V0mut+j7A75akRNUX/iXq8OU3r0FmSSYCTFf+nSheh+Rit3biAN2ppeKAdEK
8Xua5yB4P56/Du6IUOr+emwBEowFZdVdajriyKn/LpHmImAO8TeTIdkCHAbqON83
cT6adCNSqdjILqxfB7TLocNwVYu9AS+fN+08cGW7Hut0AcWIxcJBX/dleQejanZn
6PZlmyq/emLi2RK+npwJ/WEk0ryzgOi3IIf5Ux2WaF8NWym77XZPKvS+sAZ9M0cY
ug/f75G80pY+ss+Lv9kw/E0VQve9a7EqD5C2f0gPIx6ABWjkpdu2M+pHGyVJDZ09
LclBfw/dzle7+IMu4uPVaDaBBxSYUDNjy65jXiomhxBoZ2jOn0tDiUeQh4ga9gCt
n0mT1sbNNBJsMg43NM9zosTAO4lezr5WdcucvvR9nDkYcMEL8Go7HR2CWHelUn75
TRwUZICDCuulwdsuKNzSEvc+CuURKFkQ7OI/6yOM74yXM3TYhd9Ck8citIFmP3K2
L9CgGl6ZjfvSriCQhslEnTsCAwEAAQ==
-----END PUBLIC KEY-----
EOF
        "pm-sa" = <<EOF
-----BEGIN PUBLIC KEY-----
MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAurV4sYLX5HDF7IQLmVUd
gPnwf7X+Z9IfGx/uR9EYo5DcuqzpkMX73+6Z/jVSEueiJJ1ZuJbpUNPJFNe3pW4x
8tjDQEy3itgfpG1xKBlYHjPuBY6wHaR4fT3H3tTZlaMPyTT1+jYun70w/Cao9S4Y
35lxb9rLXsKeCLVbKfyodYl4j4l6Y1BfCogy9cHnOFFkhZtVM+p3m7VqpbAZF/mP
KcllPuSrQriOvBn8QM3J723G8iz9jmHTbLbTOaOg05G3aTtCEo/n3OddsiPAsHdZ
GI0eRKRrECPmiBOAVFPGWENU5xrBYBJaylxq0gyunIfmiA+eL6JCLYGEoMaUbPZG
1JmIJJPorpcOgo6KzUkYC2kAhJYUErArP64aGINBzdqCiKzRICHEr66bmlqU5vDO
JxBSoaAGn86b5bKD/s9+qH71egCn7+3aTEF6QYXgTg3o+HxJ2HGBvKoB7YwUVtOM
4Wa3+lk1hxkLOqZS7haf74LyALlVP14rWXbL3MyZvOWHsALVcnFR45dc+/szvHjs
HDwyZZkd/UA+ONz6+6wbjkNUaxIBFeyvuvNjRIoOTmHTr1KO1llpDZAkL5FeVIPb
OvqJDKDNSEvfkojyrhxVawSnHGeI9g3yYa8LuHu7wYTvYSsDyQLUV5Bb+EHQT9w5
PfHIIlcJXSIgZWBdiJbF7Z8CAwEAAQ==
-----END PUBLIC KEY-----
EOF
        "fetcher-sa" = <<EOF
-----BEGIN PUBLIC KEY-----
MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA28BEbcgknZA14pEIT03/
rNtVPYjzwOOkRZd+VUfZYsWnrYsmji7rbkQcLmVD79fyRqx56NWl5x9RFL6f+PnD
EPv/55nMZbrtelcb8jjUfJvTy7gHbRRkhTT22ZmhjS4kKdr7klD6QdatZy97OQUT
fvANozCLVr5F9hcBcSgvh/6D3zNrZVMwEFmrEZj+lvEof+Psk7pgdVvxNDjMEJAz
mUM1vu/SzXNPUJkok9ym9XVwc65qgA0k6yalj9Pal14jpH7iBsvKwEJ1TkpDWQm9
9+9rV/MTO5Ab/AicYBGYIzBjYB1FoVdlqi9KRF9J01Dpi1w7zdPLJaEFN9uSE8d0
4n9HwyzuLwdi+WqNVqjRuCGYaqoLsaXHZKA7jdvj7cClab0+3ryy9/k/wkF0Cp2v
sxvDLRaQg1q5pE6DZy4htwAHYTvy88E7R5/+rudN3pqWyXSuKVMqQB5acd3vkdpW
mRLiETSK7fXsGiHrr5ypiN0gXBcfRcKBLijRirTiLKRBgEe13XBILps4yns6SH2c
DKICnVcepQ6fGkW4jYqwJBhqANawBWAgHJIf2kwdXN4PWbaMz9zCwLOF6qSFYBfU
RY4JBYbQs7ymceCTcSWtc5RIHQzJIOx+ApEVvLAWHAr8I2aF3tIwcjG+FQCH8Sng
lbhFvJCsw6zIqbZedsDRzz8CAwEAAQ==
-----END PUBLIC KEY-----
EOF
        "ydb-sa" = <<EOF
-----BEGIN PUBLIC KEY-----
MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAuT6OeoIMi0lLqd+p40Fh
u9MEif/vFffrBHrFCuX80ImQCtXs4VK1XYhE7XWAkFgw0qd7M0i/Uu11uGWgnbd2
g9jo9JGZ1qe09bg1omUuKnojafgd6mVpYPpCvJ4HtQREKsi3v7sHVmpbmYyGbTnQ
FK3HqbdediSP07gR3TG3QTOlmfHWYCVlJG3UHxmO2ET64Y8hncW7U5WSTf5DdvVe
gtMrCLYt2LU33Ol5M8jFhn3shuA68it3xRWXbYy7MkFxHzB+BYDRCJAdKkRxwe28
MuAGLS4JhLpDIRqoLmIRoRQseSFGOCpHKlLll60Xc1IYZ1nv5xMK/r/14rTuPjIy
3RU5ULhYlocYY/BMsYlKSIPsWMNiNvO8g3mASujrhjtTvQ9TpKnweRNJB8dxw7Bf
be1EATxigNluBkVnX7D56xYyroIgTdkrACbxvSy3iu5E0ImWHFwh5Y2Erpumvv8o
7GUqHU5zK35deYIy4Mj4DaXA6nkAxvU2jA+SWaghmgJHJYW917ToV1n5SnvOddFX
wQ4NsyLOgjOqtm3oXDXITSL6VS0EQe1fAyHQIIcwu/W2t8DSZlsuqW8JNA4sziz9
CNNnLqtPe+MinDc6efLmSqeyPGfO4v41WNouPBF3rx2TEvrbEdPGWUFys29xdbx5
hzTMzPb4cwjqhJlaf1gzPNkCAwEAAQ==
-----END PUBLIC KEY-----
EOF
    }
}

variable "logs_disk_id" {
    type = string
    default = "logs-disk"
}

// NET ================================================

variable "certs" {
    //
    // for GlobalSign certs
    // https://wiki.yandex-team.ru/cloud/devel/certificate-manager/ycm-internal-providers/#kakvypisatglobalsignsertifikat
    //
    type = map(object({
        domains = list(string)
        cert_provider = string
        challenge_type = string
        folder_id = string
    }))
    default = {
        solomon = {
            domains = ["solomon.cloud-preprod.yandex.net"]
            cert_provider = "INTERNAL_CA"
            challenge_type = "CHALLENGE_TYPE_UNSPECIFIED"
            folder_id = "yc.monitoring.gateway"
        }
        pm = {
            domains = ["pm.mon.cloud-preprod.yandex.net"]
            cert_provider = "INTERNAL_CA"
            challenge_type = "CHALLENGE_TYPE_UNSPECIFIED"
            folder_id = "yc.monitoring.pm"
        }
        monitoring-api = {
            domains = ["monitoring.api.cloud-preprod.yandex.net"]
            cert_provider = "INTERNAL_CA"
            challenge_type = "CHALLENGE_TYPE_UNSPECIFIED"
            folder_id = "yc.monitoring.gateway"
        }
        monitoring-private-api = {
            domains = ["monitoring.private-api.cloud-preprod.yandex.net"]
            cert_provider = "INTERNAL_CA"
            challenge_type = "CHALLENGE_TYPE_UNSPECIFIED"
            folder_id = "yc.monitoring.gateway"
        }
    }
}

variable "underlay_fqdn" {
    type = string
    default = "under.mon.cloud-preprod.yandex.net"
}

variable "set_nlb" {
    type = bool
    default = true
}

variable "nlb_region_id" {
    type = map(string)
    default = {
        preprod = "ru-central1"
        prod = "ru-central1"
    }
}

variable "balancers" {
    type = map(object({
        ports = list(object({
            name = string
            real = number
            virtual = number
        }))
        addrs = list(string)
        ip_version = string
        group = string
        health_port = number
        yandex_only = bool
    }))
    default = {
        solomon = {
            ports = [{
                name = "http"
                real = 80
                virtual = 80
            },{
                name = "https"
                real = 443
                virtual = 443
            }]
            ip_version = "ipv6"
            addrs = ["2a0d:d6c0:0:ff1c::6"]
            group = "gateway"
            health_port = 80
            // set to false only to make tf happy (it tries to change to true each execution): looks like api is not acknowledging this setting
            yandex_only = false
        }
        manager = {
            ports = [{
                name = "http"
                real = 80
                virtual = 80
            },{
                name = "https"
                real = 443
                virtual = 443
            }]
            ip_version = "ipv6"
            addrs = ["2a0d:d6c0:0:ff1c::6b"]
            group = "pm"
            health_port = 80
            // set to false only to make tf happy (it tries to change to true each execution): looks like api is not acknowledging this setting
            yandex_only = false
        }
        monitoring-api-v4 = {
            ports = [{
                name = "https"
                real = 4443
                virtual = 443
            },{
                name = "http"
                real = 4480
                virtual = 4480
            }]
            ip_version = "ipv4"
            addrs = ["51.250.49.51"]
            group = "gateway"
            health_port = 80
            yandex_only = false
        }
        monitoring-api-v6 = {
            ports = [{
                name = "https"
                real = 4443
                virtual = 443
            },{
                name = "http"
                real = 4480
                virtual = 4480
            }]
            ip_version = "ipv6"
            addrs = ["2a0d:d6c0:0:ff1c::1d4"]
            group = "gateway"
            health_port = 80
            yandex_only = false
        }
    }
}

// https://bb.yandex-team.ru/projects/CLOUD/repos/bootstrap-templates/browse/terraform/prod/shared/outputs.tf
variable "ipv4_prefixes" {
    type = map(string)
    default = {
        ru-central1-a = "172.16.0.0/16"
        ru-central1-b = "172.17.0.0/16"
        ru-central1-c = "172.18.0.0/16"
    }
}

// https://bb.yandex-team.ru/projects/CLOUD/repos/bootstrap-templates/browse/terraform/prod/shared/outputs.tf
variable "ipv6_prefixes" {
    type = map(object({
        subnets = map(string)
        netmask = number
        new_bits = number
        project_id = number
    }))
    default = {
        preprod = {
            subnets = {
                ru-central1-a = "2a02:6b8:c0e:501::/64"
                ru-central1-b = "2a02:6b8:c02:901::/64"
                ru-central1-c = "2a02:6b8:c03:501::/64"
            }
            netmask = 32
            new_bits = 16
            project_id = 64669 // == 0xfc9d == https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_CLOUD_MONITORING_PREPROD_NETS_
        }
        prod = {
            subnets = {
                ru-central1-a = "2a02:6b8:c0e:500::/64"
                ru-central1-b = "2a02:6b8:c02:900::/64"
                ru-central1-c = "2a02:6b8:c03:500::/64"
            }
            netmask = 32
            new_bits = 16
            project_id = 63652 // == 0xf8a4 == https://racktables.yandex-team.ru/index.php?page=services&tab=projects&project_name=_CLOUD_MONITORING_PROD_NETS_
        }
    }
}

// DNS ================================================

variable "dns_zone_id" {
    type = string
    default = "yc.bootstrap.monitoring"
}

variable "dns_zone" {
    type = map(string)
    default = {
        preprod = "mon.cloud-preprod.yandex.net"
    }
}

variable "set_ptr" {
    type = bool
    default = true
}
