# Monitoring gRPC API

В данном разделе описан программный интерфейс (API) взаимодействия с Monitoring.

Monitoring gRPC API позволяет управлять дашбордами в Monitoring UI.

Адреса для подключения к gRPC API для каждого кластера Monitoring перечислены в разделе [{#T}](../../overview/clusters.md).

Работа с API осуществляется при помощи proto спецификаций и gRPC вызовов.

## Аутентификация {#auth}

Для доступа к API необходимо пройти аутентификацию. На данный момент поддерживается аутентификация по OAuth-токенам, IAM-токенам Яндекс.Облака и TVM-тикетам. Подробнее механизмы аутентификации описаны в разделе [{#T}](../authentication.md).

## Описание API {#resources}

API организовано по ресурсам. Действия с ресурсов выполняются при помощи RPC вызовов. [Описание основных концепций API.](https://cloud.yandex.ru/docs/api-design-guide/)

<small>Таблица 1 — Типы ресурсов поддерживаемые в Monitoring gRPC API.</small>

Сервис|Описание|Примеры использования
------|--------|--------
[DashboardService](./dashboard/dashboard_service.md) |Набор методов для управления дашбордами.|[grpcurl](../../operations/dashboard/examples.md)

## Обработка ответов мутирующих операций

Все операции, которые изменяют состояние ресурса (создание, изменение, удаление), имеют асинхронную сигнатуру. Это означает, что при вызове этих операций сервер возвращает объект [Operation](https://a.yandex-team.ru/arc_vcs/solomon/protos/api/v3/operation.proto).

Объект Operation содержит информацию об операции: статус, идентификатор, дату создания и др. Обращаясь к этому объекту, вы можете отслеживать статус операции. Статус операции отображается в поле *done*. Если поле принимает значение `true`, операция была завершена; в противном случае операция еще не выполнена. На текущий момент все операции синхронные и всегда возвращают `done=true` или ошибку.

Если в ходе выполнения асинхронной операции возникла ошибка, сервер отменяет все запущенные процедуры. В объект *Operation* будет добавлено поле error с описанием ошибки.

При получении в ответ *Operation* необходимо:
- проверить поле *done* (сейчас всегда `true`);
- проверить поле *error* на ошибки;
- получить ответ из поля *response*.

Пример ошибки:
```
code: 6
message: "ALREADY_EXISTS: Name must be uniq in parentId"
```


## Обработка ошибок {#error-handling}

При возникновении ошибки Monitoring API вернут gRPC `status != OK`. В теле ответа будет содержаться более подробное описание ошибки в следующем формате:

```
code: <number> код ошибки
message: <string>  текст ошибки
```

Пример сообщения об ошибке:
```
code: 6
message: "ALREADY_EXISTS: Name must be uniq in parentId"
```

{% note info %}

На данный момент нет фиксированного списка кодов ошибок, поэтому поле *code* зарезервировано для использования в следующих версиях Monitoring.

{% endnote %}

{% note tip %}

Рекомендуется логировать сообщения об ошибках при получении ответа со `status != OK`, чтобы при [сообщении о проблеме](../../problems/howtoreport.md) команде Monitoring было проще разобраться с проблемой.

{% endnote %}

### Конфликты при обновлении объектов {#conflicts-resolution}

Для разрешения конфликтов при модифицирующих операциях используется не обязательное поле *etag*: поле можно передавать в мутирующих операциях, получить его можно при помощи **GET**. Объект будет модифицирован, только если никто не изменил объект и *etag* в операции совпадает с значение сервера. В случае ошибки необходимо получить новый *etag* и повторить операцию.

*etag* - опциональное поле, если его не передавать, то будет применяться **last write wins**.
