# Антипаттерны в организации метрик

В этом разделе описаны типичные антипаттерны в организации данных, которые приводят к быстрому исчерпанию квоты или к созданию избыточной нагрузки на сервис Solomon, и рекомендации по их исправлению.

## Пользовательский ввод в значениях меток {#user-input}

Запись метрик с метками, содержащими нефильтрованный пользовательский ввод, может привести к быстрому исчерпанию квоты или к утечке чувствительной информации — токенов, ключей.

Например, распространённым сценарием является сбор метрик времени ответов сервера, когда URL записываются в одну из меток. Веб-сервисы часто проходят тестирование безопасности, одним из элементов которого является перебор доступных URL при помощи [фаззинга](https://ru.wikipedia.org/wiki/Фаззинг). Если значение метки с URL не фильтруется, такая проверка приведёт к генерации множества метрик в Solomon.

Рекомендуется фильтровать возможные значения меток по белому списку или при помощи регулярных выражений. Не прошедшие фильтрацию значения можно заменять зарезервированной строкой, например, `UNKNOWN`. Пример (отфильтрована метка `projectId`):

```
host="cluster", sensor="stockpile.host.bytes.count", projectId="SOLOMON"
host="cluster", sensor="stockpile.host.bytes.count", projectId="GOLOVAN"
host="cluster", sensor="stockpile.host.bytes.count", projectId="GRAPHITE"
host="cluster", sensor="stockpile.host.bytes.count", projectId="UNKNOWN"
```

## Метки с неограниченной размерностью {#infinite-cardinality}

Запись в значение меток элементов с неограниченной размерностью может привести к быстрому исчерпанию квоты.

**Work in progress...**

## Мониторинг сущностей, не привязанных к хосту {moving-entities}

Если в системе есть сущности, перемещающиеся по хостам (переезжающие шарды; операции под блокировкой, всегда выполняющиеся только на одном хосте, и т.п.), может возникнуть ситуация, когда вместо одной метрики на каждую такую сущность собирается множество метрик на каждую пару сущность-хост. Это происходит потому, что Solomon автоматически добавляет ко всем метрикам, собираемым через pull, метку `host`.

В таких ситуациях можно отказаться от использования метки `host`, чтобы уменьшить использование квоты на количество метрик. Для этого в метриках подобных сущностей нужно явно передать метку `host=""` (пустая строка). Получив такие данные, Solomon не будет добавлять метку `host` к метрикам.

Если сущность может обслуживается несколькими хостами в каждый момент времени и метрики для них достаточно просто просуммировать (но при этом разбиение по хостам неинтересно), то включите опцию *Store only aggregates* в настройках Solomon-сервиса (при этом не нужно добавлять метку `host=""`). Таким образом, в шарды, подключённые к этому сервису, будут записываться только метрики-агрегаты, а похостовые метрики — не будут. Потребление квоты на количество метрик в шарде уменьшится пропорционально количеству хостов в наблюдаемой системе, но при этом похостовые метрики начнут потреблять квоту memonly-метрик.

## Отсутствие предагрегации на клиенте {#client-aggregation}

Каждое правило агрегации удваивает количество операции записи в хранилище Solomon. Чтобы не создавать повышенную нагрузку на систему мониторинга, рекомендуется использовать правила агрегации только для вычисления пред-агрегатов, которые невозможно вычислить на клиенте в рамках одного хоста: например, агрегация по всем хостам кластера или агрегация по дата-центрам. Пред-агрегацию, например, по методам API, которые обрабатывает конкретный хост, рекомендуется делать непосредственно на этом хосте.

Например, такой список метрик может собираться с хоста `solomon-storage-000`, при этом пред-агрегация в метрику с меткой `projectId="total"` выполняется на клиенте, а не на серверной части Solomon:

```
host="solomon-storage-000", sensor="stockpile.host.bytes.count", projectId="SOLOMON"
host="solomon-storage-000", sensor="stockpile.host.bytes.count", projectId="GOLOVAN"
host="solomon-storage-000", sensor="stockpile.host.bytes.count", projectId="GRAPHITE"
host="solomon-storage-000", sensor="stockpile.host.bytes.count", projectId="total"
```
