# Удаление метрик по селектору

В данном разделе описан механизм работы удаления метрик по заданному селектору.

Удаление метрик по селектору полезно в следующих ситуациях:
- необходимо удалить неактуальные метрики в шардах с отключенным [TTL](./ttl.md); 
- необходимо удалить метрики как можно быстрее, т.к. срочно требуется освободить [квоту](../limits.md);
- необходимо явно контролировать какой набор метрик должен быть удален;
- необходимо удалить метрики с возможностью восстановления.

[Пошаговая инструкция](../../operations/metrics/deletion.md) по удалению метрик с помощью API приведена в соответствующем разделе. 

{% note info %}

В настоящий момент доступ к API для удаления метрик Голована ограничен. 

Если вам нужно удалить метрики из Голована, создайте заявку через [форму](https://st.yandex-team.ru/createTicket?queue=MONITORINGREQ&_form=87264).

{% endnote %}

## Принцип работы {#how-it-works}

### Запуск {#run}

Удаление метрик производится в рамках конкретного [проекта](../glossary#project) по заданному [селектору](../glossary#selector). Удаление может занимать продолжительное время, с каждым запуском ассоциирована собственная асинхронная операция.

По полученному идентификатору операции можно отследить ее статус и прогресс, а также запросить отмену.

{% note warning %}

Метрики, подпадающие под условия селектора, должны целиком содержаться ровно в одном [шарде](../glossary#shard). Мульти-шардовые удаления в данный момент не поддерживаются. В случае необходимости удалить метрики из нескольких шардов, необходимо запустить отдельную операцию удаления для каждого из шардов.

{% endnote %}


### Удаление {#del}

По указанному селектору операция определяет набор метрик, подлежащих удалению, и проверяет, что эти метрики не являются активными в данный момент (запись в них прекращена).

В случае успеха, начинается стадия непосредственного удаления, **по завершению которой метрики считаются удаленными** с точки зрения работы системы Solomon. После этого операция переходит в статус ожидания окончательного удаления. 

{% note warning %}

Удаление не произойдет, если в метрики, подпадающие под условия селектора, идет запись. В данный момент пороговым значением для проверки является 1 час. В случае обнаружения записи точек с временными метками в пределах последнего часа, процесс удаления досрочно завершается с ошибкой. В таком случае, никакие из метрик, подпадающих под условия, удалены не будут.

{% endnote %}

### Отмена {#cancel}

Удаление является обратимым процессом: операцию можно отменить в течении некоторого времени после запуска и восстановить удаленные метрики. Отмена также занимает продолжительное время, прогресс восстановления можно запросить по идентификатору операции.

Допустима ситуация, когда в силу обстоятельств ([метки](../glossary#label) были переиспользованы, исчерпание квоты) процесс восстановления не может обратить удаление некоторых метрик. Операция будет производить повторные попытки восстановления оставшихся метрик. В таких случаях можно изменить обстоятельства (удалить метрики с конфликтующими метками, запросить увеличение квоты) или оставить все как есть. В случае если восстановление оставшихся метрик так и не завершится успехом, они будут удалены окончательно по истечении запланированного времени.

{% note info %}

Восстановление недоступно для операций, содержащих метрики, подпадающие под удаление по условиям текущих настроек TTL. Восстановление станет доступным, если в результате изменения настроек TTL все метрики, удаленные этой операцией, не будут подпадать под условия TTL.

{% endnote %}

### Завершение {#completion}

По истечении периода времени приблизительно равному 30 дням, метрики и их данные удаляются окончательно, а операция считается завершенной.

В случае запроса на отмену, происходит отсрочка перманентного удаления на 7 дней (дополнительное время, чтобы решить потенциальные проблемы с конфликтом меток/квотами). Если восстановление выполняется успешно и в полном объеме, то операция незамедлительно завершается. 

Точный момент наступления окончательного удаления можно запросить по идентификатору операции.


## Гарантии {#properties}

- За исключением явной отмены и случая, описанного ниже, метрики, подпадающие под условия селектора на момент старта операции, в конечном счете будут удалены.

- Процесс удаления завершаем. В случае, если в процессе удаления, в метрики, подпадающие под условия селектора, возобновится запись, то удаление всего набора метрик не гарантируется. К моменту завершения операции дописанные данные могут быть как удалены, так и не удалены.

- Метрики, подпадающие под условия селектора, но созданные после момента старта операции, удалены не будут.

- При одновременном запуске нескольких операций удаления, для которых множество удаляемых метрик совпадает целиком или частично, гарантируется, что все метрики попадающие в объединение этих множеств будут удалены, однако нет гарантий о том, как метрики из пересечения этих множеств распределятся между этими операциями.

- Метрики могут быть восстановлены через отмену операции в любой момент до наступления времени окончательного удаления, в случае отсутствия конфликтов имен/меток и превышения квот. При отмене операции восстановлению подлежат только те метрики, которые были фактически удалены в рамках этой операции.
