# Квоты и лимиты

В сервисе Solomon действуют следующие ограничения:

* *Квоты* — организационные ограничения, которые можно изменить по [запросу к команде Solomon](../problems/howtoreport.md#quotas);
* *Лимиты* — технические ограничения, обусловленные особенностями архитектуры Solomon. Изменение лимитов невозможно.

## Квоты {#quotas}

В системе Solomon существуют следующие квоты:
- количество метрик, записываемых в долговременное хранилище (файловые метрики);
- количество [memonly-метрик](glossary.md#memonly), хранящихся только в памяти процессов Solomon для вычисления пред-агрегатов при записи (подробнее этот механизм описан в разделе [{#T}](aggregation.md#aggregation-on-write));
- количество метрик в ответе, принимаемых от одного источника.

Квоты ограничивают количество метрик, хранящихся в каждом [шарде](glossary.md#shard) Solomon. Значения квот по умолчанию для новых шардов перечислены в Таблице 1.

<small>Таблица 1 — Значения квот по умолчанию для нового шарда.</small>

Квота | Значение по умолчанию
----- | -----
Количество файловых метрик в шарде | 1 000 000
Количество memonly-метрик в шарде | 500 000
Количество метрик в ответе | 10 000

{% note info %}

В следующих версиях Solomon планируется привязывать квоты к проекту.

{% endnote %}

В случае, если шард близок к исчерпанию квоты и запись в него новых метрик приведет к ее превышению, то новые метрики перестают записываться в шард. При этом новые значения уже хранящихся в шарде метрик продолжат записываться.

Например, пользовательское приложение передает в определенный шард 900 000 метрик, а квота на количество метрик в этом шарде равно 1 000 000 хранимых метрик. Если в какой-то момент пользовательское приложение начнет передавать в Solomon на 300 000 метрик больше (то есть всего 1 200 000 метрик), то новые значения запишутся для уже существующих в шарде 900 000 метрик, а также для первых полученных 100 000 метрик из добавившихся 300 000. Значения оставшихся 200 000 метрик не будут записаны в Solomon.

{% note info %}

Из-за особенностей работы механизма квотирования при превышении квоты может возникнуть переподписка: то есть в шард может быть записано несколько больше метрик, чем ограничено квотой. Например, 1 030 000 метрик при значении квоты в 1 000 000 метрик. На это поведение системы не стоит полагаться при построении production-процессов.

{% endnote %}

{% note warning %}

Пользователи должны самостоятельно следить за квотами на выделенные ресурсы и своевременно заказывать их увеличение при необходимости. О том как настроить мониторинг квот своего аккаунта можно узнать в разделе [{#T}](../best-practices/quota-monitoring.md).

{% endnote %}

## Лимиты {#limtis}

В следующих разделах перечислены лимиты, действующие в системе Solomon.

### Лимиты модели данных {#common-limits}

В Таблице 2 перечислены лимиты, накладываемые [моделью данных](data-model.md) Solomon.

<small>Таблица 2 — Лимиты модели данных.</small>

Вид ограничения | Значение
--------------- | --------
Максимальное количество меток у одной метрики<br/>(включая обязательные) | 16
Минимальный интервал времени между двумя значениями метрики | 1 секунда

### Лимиты языка запросов {#expression-limits}

В Таблице 2 перечислены лимиты, связанные с использованием [языка запросов](querying.md) Solomon.

<small>Таблица 2 — Лимиты языка запросов Solomon.</small>

Вид ограничения | Значение
--------------- | --------
Максимальное количество метрик обрабатываемых одним выражением на [языке запросов](querying.md) | 10 000
Максимальное количество метрик обрабатываемых [функциями ранжирования](querying.md#rank-functions) | 20 000


### Лимиты алертинга {#alerting-limits}

В Таблице 3 перечислены лимиты действующие в системе [алертинга](alerting/index.md) Solomon.

<small>Таблица 3 — Лимиты алертинга Solomon.</small>

Вид ограничения | Значение
--------------- | --------
Максимальное количество метрик обрабатываемых одним алертом | 100
Максимальное количество отправленных SMS на один номер в сутки | 50


### Лимиты API {#api-limits}

В Таблице 4 перечислены лимиты, связанные с использованием [{#T}](../api-ref/rest.md).

<small>Таблица 4 — Лимиты Solomon API.</small>

Вид ограничения | Значение
--------------- | --------
Максимальное количество метрик, возвращаемое в API-запросе на выгрузку данных | 500
Максимальное количество метрик, передаваемое в API-запросе на загрузку данных | 10 000
Минимальное количество точек, возвращаемое в API-запросе на выгрузку данных | 10
Максимальное количество точек, возвращаемое в API-запросе на выгрузку данных | 10 000

### Лимиты на размера шарда {#shard-limits}

В Таблице 5 перечислены лимиты на размер шарда. При превышении этих лимитов уровень обслуживания для данных, поступающих в шард, не гарантируется.

<small>Таблица 5 — Лимиты на размер шарда.</small>

Вид ограничения | Значение
--------------- | --------
Максимальный поток на запись в шард | 1 000 000 точек/секунду
Максимальное количество файловых метрик в шарде | 20 000 000 метрик
Максимальное количество memonly-метрик в шарде | 20 000 000 метрик
