## Отладка Solomon Agent

В этом разделе описаны способы диагностики и самостоятельного решения проблем с Solomon Agent (далее — «Агент»).

{% note warning %}

Перед созданием тикета о возможной проблеме в работе Агента, пожалуйста:
1. Обновите Агент до последней версии.
1. Настройте [сбор внутренних метрик](#internal-metrics) Агента.
1. Проверьте возможные проблемы, описанные ниже — возможно, вы можете устранить или найти проблему на своей стороне.

В тикет приложите: логи Агента, конфиг Агента, ссылку на внутренние метрики Агента.

{% endnote %}

## Сбор внутренних метрик Агента {#internal-metrics}

Помимо пользовательских метрик Агент также умеет передавать метрики о своей собственной работе. В их число входит информация о:
* запросах на чтение пользовательских метрик из хранилища Агента;
* размерах шардов в памяти и размере вымытых данных;
* отправленных PUSH-запросах;
* размере аллоцированной памяти в Python-модулях;
* временах работы модулей;

Таким образом, можно проследить поведение Агента во времени и выполнить диагностику процесса передачи пользовательских метрик в Solomon.

Полный набор метрик:

Имя метрики | Значение
:--- | :--- | :---
`execTimeMs` | Время выполнения модулей в миллисекундах
`http.storage.read.*` | Метрики запросов на чтения из хранилища Агента: коды возврата, кол-во ошибок запросов и другое
`logger.entryCount` | Количество записей в логах соответствующих уровней (INFO, DEBUG и т.д.)
`process.*` | Метрики о процессе Агента: uptime, cpu и пр
`python.AllocatedBytes` | Количество выделенной памяти интерпретатором Python:
`python.AllocatedBytes{domain=Raw}` | прямые вызовы системного аллокатора, не используется при нормальном режиме работы;
`python.AllocatedBytes{domain=Mem}` | внутренние объекты интерпретатора, арены памяти, объекты больших размеров;
`python.AllocatedBytes{domain=Obj}` | объекты, выделяемые при исполнении кода
`storage.bytesEvicted` | Количество байт, вымытых из хранилища Агента из-за превышения лимита
`storage.bytesRead` | Количество байт, прочитанных из хранилища Агента за время жизни процесса Агента
`storage.bytesWritten` | Количество записанных байт в хранилище Агента за время жизни процесса Агента
`storage.fetcher.lag` | Величина, показывающая, насколько сильно Solomon Fetcher отстаёт от свежих данных в Агенте
`storage.limitBytes` | Значение лимита на размер хранилища Агента в байтах (общий лимит и в разбивке по шардам)
`storage.pointCount` | Количество точек (значений пользовательских метрик) в хранилище Агента
`storage.sizeBytes` | Количество памяти в байтах, занимаемой шардами в хранилище Агента
`threadPool.activeThreads` | Количество активных тредов Агента
`threadPool.queueSize` | Размер очереди в тред-пуле Агента
`threadPool.waitTimeUs` | Время в микросекундах между добавлением новой задачи в тред-пул Агента и её запуском
`version` | Версия (ревизия) Агента


Для сбора внутренних метрик Агента:
1. Добавьте в корневой конфигурационный файл Агента `agent.conf` секцию [ManagementServer](usage.md#managementserver). В ней описывается, на каких порту и адресе будет запущен HTTP-сервер, из которого можно запрашивать внутренние метрики. Пример файла `agent.conf`, запускающий ManagementServer на порту 8081:

    ```
    ...
    ManagementServer {
        BindAddress: "::"
        BindPort: 8081
    }
    ...
    ```

    Чтобы проверить, что ManagementServer работает и отдаёт внутренние метрики Агента, выполните следующую команду:

    ```bash
    $ curl -g 'http://localhost:8081/counters/json' | python3 -m json.tool
    {
      "sensors": [
        {
          "kind": "RATE",
          "labels": {
            "sensor": "logger.entryCount",
            "logLevel": "INFO "
          },
          "value": 4
        },
    ...
    ```
1. Заведите новый PULL-сервис в вашем Solomon-проекте:
    - В параметре **Port**  укажите значение из файла `agent.conf`, указанное ранее. В данном примере — 8081.
    - В параметре **URL Path** укажите `/counters/spack`.
1. Создайте шард: подключите созданный сервис к кластеру, на котором установлен Агент.
1. После этого внутренние метрики Агента начнут поступать в созданный шард.

## Проверка данных в Агенте {#data-check}

Чтобы проверить, какие пользовательские метрики в данный момент находятся в хранилище Агента в шарде `(Project: "my_project"; Service: "my_serivce")`, выполните следующую команду, где `port` – порт, на котором запущен Агент:

```bash
$ curl -g 'http://localhost:<port>/storage/read?project=my_project&service=my_service'

{
    "sensors": [
        {
            "kind":"GAUGE",
            "labels": {
                "mountpoint": "/mount",
                "path": "/Filesystem/SizeB"
            },
            "value": 1073741824
        }
    ]
}
```

{% note warning %}

* Будьте осторожны с написанием собственного кода для чтения данных из хранилища Агента. Без передачи дополнительного заголовка `X-Solomon-FetcherId` прочитанные таким образом данные никогда не будут вымываться из хранилища Агента, пока не произойдёт OOM. Поэтому в таком режиме эта ручка подходит только для отладки.
* Пожалуйста, не присылайте в тикет содержимое хранилища Агента для исследования — лучше настройте сбор метрик в проект Solomon и приложите ссылку на шард. Во-первых, исследовать ответ в формате JSON не так удобно, как на графиках. Во-вторых, эти метрики полезно смотреть на протяжении времени и их показания в какой-то точечный момент не скажут многого.

{% endnote %}

Если вы не помните значения `Project` и `Service` или не уверены, что такой шард зарегистрирован в Агенте, получить список всех шардов Агента можно выполнив следующую команду, где `port` – порт, на котором запущен Агент:

```bash
$ curl -g 'http://localhost:<port>/storage/shards?pretty=true'

[
  {
    "project":"test-project",
    "service":"test-service"
  },
  {
    "project":"test-project",
    "service":"sys"
  }
]
```

## Частые проблемы {#frequent-problems}

### На графике нет данных {#no-data}

В этом разделе описаны примеры проблем при использовании Агента, приводящие к отсутствию данных на графиках в Solomon

#### Ошибки Pull-модулей {#pull-modules}

##### Симптомы

1. Агент собирает пользовательские метрики при помощи [pull-модулей](modules.md#pull).
1. На графиках в Solomon не отображаются данные или отсутствуют метрики в навигации.

##### Возможная причина

В каком-то из модулей или во время сбора данных из модуля произошла ошибка.

##### Как исправить

1. Поищите в логах агента записи об ошибочных запросах и изучите код ошибки. Для Http Pull модуля запись выглядит, например, так:

    ```
    ERROR {http.cpp:77}: Request to http://10.7.131.223:9108/metrics?format=PROMETHEUS failed with code 1039
    ```

    Описания кодов ошибки Аркадийного HTTP-клиента, которым агент опрашивает HTTP Pull модули, описаны [в Аркадии](https://a.yandex-team.ru/arc/trunk/arcadia/library/cpp/http/fetch/exthttpcodes.h)
1. Если используется Python-модуль, в нём можно залогировать больше отладочной информации, например, следующим образом:

    ```python
    class MyModule:
        def __init__(self, logger, registry):
            self._logger = logger
            ...

        def pull(self, ts, consumer):
            ...
            self._logger.warn('something bad happened')
            ...
    ```

    После этого изучите логи Агента и убедитесь, что модуль действительно работает и собирает данные.

1. Пришлите описание ошибки в [телеграм-чат](https://t.me/joinchat/AWy4SEK1sYQoq4Ign2oINQ) поддержки Solomon или приложите к тикету в очереди [SOLOMON](https://st.yandex-team.ru/createTicket?queue=SOLOMON&components%5B%5D=35475&priority=2&type=1).

#### Python-модуль перестал запускаться {#python-modules}

##### Симптомы

1. Агент собирает пользовательские метрики, при помощи python-модуля.
1. По внутренним метрикам Агента видно, что python-модуль больше не запускается: значение метрики `execTimeMs` для модуля равно нулю или отсутствует.

##### Возможная причина

Иногда при вызове метода `pull()` в Python модуле необходимо остановить исполнение кода. Для этого нужно вернуть код возврата из метода. Например, следующим образом:

```python
class MyModule:
    def pull(self, ts, consumer):
        ...
        if some_condition:
            return  # or return 0
        ...
```

Но если вернуть ненулевое число, модуль будет остановлен _навсегда_:

```python
class MyModule:
    def pull(self, ts, consumer):
        ...
        if some_condition:
            return 1  # this module will NEVER be executed again
        ...
```

При следующем интервале сбора данных Агент не будет запускать данный модуль до тех пор, пока [ConfigLoader](usage.md#configloader) не вернёт новый список модулей с изменениями — в этом случае все модули из списка будут запущены.

##### Как исправить

Не возвращать ненулевой код возврата — возвращать 0 или `None`.

#### Несогласованные интервалы сбора RATE метрик {#wrong-interval-values}

##### Симптомы

На графике отсутствуют данные (во всех точках значение No data). Иногда данные появляются, но редко и скачками.

##### Возможная причина

`RATE` метрика — она же производная — вычисляется путём подсчёта разности двух последовательно идущих значений. К примеру, если есть метрика RPS, то в Solomon она может записываться так:

Временная метка | Значение метрики | Что будет записано в Solomon
:--- | :--- | :---
2020-07-08 10:37:30 | 5 | No data (первое значение)
2020-07-08 10:37:45 | 10 | 10 - 5 == 5
2020-07-08 10:38:00 | 18 | 18 - 10 == 8

Если же в одном или нескольких интервалах значение метрики пропущено, в Solomon ничего не будет записано:

Временная метка | Значение метрики | Что будет записано в Solomon
:--- | :--- | :---
2020-07-08 10:37:30 | 5 | No data (первое значение)
2020-07-08 10:37:45 | //значение пропущено// | No data
2020-07-08 10:38:00 | 18 | 18 - No data == No data

Рассмотрим следующий пример. Допустим, что:
1. В Solomon настроен сервис для сбора RATE-метрик. из Агента каждые 15 секунд.
2. Агент опрашивает модули, возвращающие RATE-метрики, каждые 60 секунд.
Пример конфигурации Агента:
```
Project: "my_project"
Service: "pull_modules"

PullInterval: "60s"

Modules: [
    { HttpPull: {
        Url: "http://localhost:1337"
        Format: JSON
    }}
```

Тогда в Solomon будут поступать следующие данные:

Время поступления точки | Значение | Что будет записано в Solomon
:--- | :--- | :---
2020-07-08 10:37:30 | 5 | No data (первое значение)
2020-07-08 10:37:45 | ничего не пришло | No data
2020-07-08 10:38:00 | ничего не пришло | No data
2020-07-08 10:38:15 | ничего не пришло | No data
2020-07-08 10:38:30 | 10 | 10 - No data == No data
2020-07-08 10:38:45 | ничего не пришло | No data
2020-07-08 10:39:00 | ничего не пришло | No data
2020-07-08 10:39:15 | ничего не пришло | No data
2020-07-08 10:39:30 | 15 | 15 - No data == No data

Таким образом, в Solomon не будет записано ни одно значение RATE-метрики.

##### Как исправить

Проверьте, что интервал сбора метрик в настройках Solomon-сервиса и интервал запуска pull-модулей в конфигурации Агента совпадают.


### Пропуски в данных (дырки на графиках) {#holes}

В этом разделе описаны примеры проблем при использовании Агента, приводящие к пропуску в данных передаваемых в Solomon и следовательно к «дыркам» на графиках.

#### Вымывание данных {#data-eviction}

##### Симптомы

1. Пропуски в данных (дырки на графиках);
2. Метрика `storage.bytesEvicted` показывает ненулевое значение.

##### Возможная причина

Допустим, в конфигурации Агента настроены следующие лимиты на размер хранилища:

```
...

Storage {
    Limit {
        Total: "4GiB"
        ShardDefault: "100MiB"
    }

    # Overrides ShardDefault for specific shards
    Shard {
        Project: "my_project",
        Service: "my_service",
        Limit: "75MiB"
    }
}

...
```

Теперь, если размер шарда `(my_project; my_service)` дойдёт до 75MiB, но в него продолжат писать данные, из него начнут вымываться самые старые записи — для того, чтобы можно было записать новые. Это приведет к дыркам на графиках метрик этого шарда.

##### Как исправить

Возможные решения:

- Увеличить в конфигурационном файле Агента лимит на шард или всё хранилище целиком;
- Собирать данные из Агента чаще, чтобы данные не успевали накапливаться;
- Передавать в Агент меньше метрик, чтобы хранилище не переполнялось.

### Агент падает по OOM {#oom}

В этом разделе описаны примеры проблем при использовании Агента, приводящие к излишнему потреблению оперативной памяти Агентом и падению процесса Агента из-за срабатывания OOM-killer.

#### Не указан лимит хранилища {#no-limit-specified}

##### Симптомы

1. В конфигурационном файле Агента отсутствует секция `Storage::Limit`.
1. Метрика `{sensor=storage.sizeBytes, storageShard=total}` ненулевая и постоянно растёт, пока не падает в 0.
1. Метрика `storage.limitBytes` для всех шардов имеет очень большое значение (порядка нескольких TiB или PiB).

##### Как исправить

В корневом конфигурационном файле Агента `agent.conf` выставить лимит на размер хранилища. Например следующим образом:

```
...

Storage {
    # determines how much historical data is held in memory if a fetcher lags behind
    Limit {
        Total: "4GiB"
        ShardDefault: "100MiB"
    }

    # Overrides ShardDefault for specific shards
    Shard {
        Project: "my_project",
        Service: "my_service",
        Limit: "75MiB"
    }

    Shard {
        Project: "my_project",
        Service: "another_service",
        Limit: "20MiB"
    }
}

...
```

Подробнее в разделе [Storage](usage.md#storage).

#### Из шарда забывают читать данные {#nobody-reads}

##### Симптомы

1. Метрика `storage.bytesEvicted` растёт только для одного (или нескольких) шардов, для остальных проблем нет.

##### Возможные причины

Скорее всего, в Агенте настроили сбор метрик, но забыли настроить их сбор со стороны серверной части Solomon.

Например, часто пользователи включают сбор Агентом системных метрик, но при этом в проекте в Solomon не создают шард, в который будут собираться эти метрики, из-за чего они копятся в памяти Агента, и приводят к OOM, если не были выставлены лимиты хранилища (подробнее в разделе [Storage::Limit](usage.md#storage)).

Пример конфигурации Агента для сбора системных метрик:

```
...

Modules {
    System: {
        Cpu: BASIC
        Memory: BASIC
        Network: BASIC
        Storage: BASIC
        Io: BASIC
        Kernel: BASIC
    }
}

...

```


