# Мониторинг системных параметров при помощи sysmond

Для мониторинга базовых системных метрик с хостов и porto-контейнеров (загрузка процессора, памяти и другие) Solomon предоставляет не требующую конфигурации программу (демон) sysmond, которая собирает метрики и работает в режиме веб-сервера, предоставляя HTTP endpoint для сбора метрик по pull-режиме в формате Solomon.

<!-- Полный список метрик, которые собирает sysmond в разделе [{#T}](./metrics-list.md). -->

## Установка {#installation}

Чтобы установить sysmond, выполните следующие действия:

1. Подключите deb-репозиторий Яндекса (`yandex-precise/yandex-trusty/yandex-xenial`), соответсвующий версии Ubuntu, на которую будет установлен sysmond, добавив в файл `/etc/apt/sources.list` следующие строки:

   ```bash
   deb http://dist.yandex.ru/yandex-xenial stable/all/
   deb http://dist.yandex.ru/yandex-xenial stable/amd64/
   ```

1. Обновите список пакетов, доступных для установки при помощи команды:

   ```bash
   sudo apt-get update
   ```
   {% note tip %}

   Если при обновлении списка пакетов возникла ошибка проверки GPG-ключей `GPG error: http://dist.yandex.ru stable/amd64 Release: The following signatures couldn't be verified because the public key is not available: NO_PUBKEY 7FCD11186050CD1A`, импортируйте недостающие ключи при помощи команды:

   ```bash
   sudo apt-key adv --keyserver keyserver.ubuntu.com --recv-keys 7FCD11186050CD1A
   ```

   {% endnote %}

1. Установите пакет **yandex-solomon-sysmond** (старое название **yandex-salmon-sysmond**) при помощи команды:

   ```bash
   sudo apt-get install yandex-solomon-sysmond
   ```

{% note info %}

sysmond не требует какой-либо конфигурации и запускается сразу после установки пакета.

{% endnote %}

## Настройка сбора метрик {#configure-pull}

Чтобы настроить сбор метрик, которые собирает sysmond, заведите в своем проекте новый сервис со следующими параметрами:

   * **Monitoring model** – `PULL`.
   * **Port** – 3443.
   * **URL Path** – `/pbbin`

{% note info %}

В качестве имени метрики в sysmond используется метка `path`

{% endnote %}

Подробнее про создание проекта и сервиса в разделе "Начало работы" ([в большом Яндексе](../../../howtostart/quickstart-yateam.md) и в [Яндекс.Облаке](../../../howtostart/quickstart-cloud.md)).

## Фильтрация метрик сетевых интерфейсов {#netif-filtration}

По умолчанию sysmond собирает метрики про все сетевые интерфейсы хоста. Возможны ситуации, когда на машине создаются короткоживущие сетевые интерфейсы, для которых не нужно собирать метрики.

Чтобы отфильтровать сетевые интерфейсы, с которых собираются метрики, добавьте к **URL Path** GET-параметр `net.intf`, значение которого содержит регулярное выражение, по которому будут отфильтрованы сетевые интерфейсы. Выражение должно обеспечивать полное совпадение (full match) имени интерфейса.

Например, если в **URL Path** указать `/pbbin?net.intf=eth.*`, sysmond соберет метрики только про сетевые интерфейсы, имя которых с префикса `eth`.

## Сбор Porto-метрик {#porto-metrics}

По умолчанию sysmond собирает метрики из [procfs](https://ru.wikipedia.org/wiki/Procfs) про хост-систему.

Чтобы настроить сбор метрик про системные ресурсы porto-контейнеров и porto-разделов необходимо добавить определенные GET-параметров к **URL Path**, как описано далее.

### Сбор метрик изнутри porto-контейнера {#sysmond-inside-porto}

Если sysmond установлен внутрь porto-контейнера, для сбора его системных метрик, добавьте к **URL Path** GET-параметр `porto.containerized=1`.

### Сбор метрик про все porto-контейнеры хоста {#sysmond-aside-porto}

Чтобы получать метрики про все porto-контейнеры хоста («внешних» по отношению к контейнеру, в котором запущен sysmond), добавьте к **URL Path** GET-параметр `porto=1`.

Чтобы отфильтровать список porto-контейнеров, с которых sysmond собирает метрики, добавьте к **URL Path** GET-параметр `porto.containerName`, значение которого содержит регулярное выражение с одной группой (capture group). Выражение должно обеспечивать полное совпадение (full match) имени контейнера. Метрики каждого контейнера дополнительно получат метку `name` со значением группы, найденной регулярным выражением.

Например, если указать параметр `porto.containerName=.+(yt_.+_nodes).+`, метрики контейнера с именем `ISS-AGENT--9012/9012_vla_yt_arnold_nodes_P6gSGme0toE1` получат метку `name` со значением `yt_arnold_nodes`.

{% note info %}

Параметр `porto.containerName` можно перечислять несколько раз, чтобы собирать метрики с разных групп porto-контейнеров.

{% endnote %}

### Фильтрация метрик porto-разделов {#porto-volumes-metrics}

По умолчанию в sysmond выключен сбор метрик с porto-разделов.

Чтобы включить сбор метрик c porto-разделов, добавьте к **URL Path** GET-параметр `porto.volumes`, значение которого содержит регулярное выражение,  по которому будут отфильтрованы точки монтирования разделов.

Например, если указать параметр `porto.volumes=/data.*|/logs` sysmond соберет метрики про разделы `/logs`, `/data`, `/data/something` и т.д.
